/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.model.appdata;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Version;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.appdata.ApplicationDataExtractor;
import org.openmicroscopy.shoola.env.data.model.appdata.LANGANDCODEPAGE;

public class WindowsApplicationDataExtractor
implements ApplicationDataExtractor {
    private static final String APPLICATION_PROPERTY_KEY_COMMENTS = "Comments";
    private static final String APPLICATION_PROPERTY_KEY_COMPANY_NAME = "CompanyName";
    private static final String APPLICATION_PROPERTY_KEY_FILE_DESCRIPTION = "FileDescription";
    private static final String APPLICATION_PROPERTY_KEY_FILE_VERSION = "FileVersion";
    private static final String APPLICATION_PROPERTY_KEY_INTERNAL_NAME = "InternalName";
    private static final String APPLICATION_PROPERTY_KEY_LEGAL_COPYRIGHT = "LegalCopyright";
    private static final String APPLICATION_PROPERTY_KEY_LEGAL_TRADEMARK = "LegalTrademark";
    private static final String APPLICATION_PROPERTY_KEY_ORIGINAL_FILE_NAME = "OriginalFileName";
    private static final String APPLICATION_PROPERTY_KEY_PRODUCT_NAME = "ProductName";
    private static final String APPLICATION_PROPERTY_KEY_PRODUCT_VERSION = "ProductVersion";
    private static final String APPLICATION_PROPERTY_KEY_PRIVATE_BUILD = "PrivateBuild";
    private static final String APPLICATION_PROPERTY_KEY_SPECIAL_BUILD = "SpecialBuild";
    private static final String WINDOWS_QUERYPATH_TRANSLATION = "\\VarFileInfo\\Translation";
    private static final String LOCATION_WINDOWS = "C:\\Program Files\\";

    private Icon getSystemIconFor(File file) {
        Icon icon = FileSystemView.getFileSystemView().getSystemIcon(file);
        return icon;
    }

    private Pointer allocateBuffer(int size) {
        byte[] bufferarray = new byte[size];
        Memory buffer = new Memory((long)bufferarray.length);
        return buffer;
    }

    private String getTranslation(String applicationPath, int fileVersionInfoSize) throws Exception {
        Pointer lpData = this.allocateBuffer(fileVersionInfoSize);
        boolean fileVersionInfoSuccess = Version.INSTANCE.GetFileVersionInfo(applicationPath, 0, fileVersionInfoSize, lpData);
        if (!fileVersionInfoSuccess) {
            throw new Exception("Unable to load application information");
        }
        PointerByReference lplpBuffer = new PointerByReference();
        IntByReference puLen = new IntByReference();
        boolean verQueryValSuccess = this.ExecuteQuery(lpData, WINDOWS_QUERYPATH_TRANSLATION, lplpBuffer, puLen);
        if (!verQueryValSuccess) {
            throw new Exception("Unable to load application information");
        }
        LANGANDCODEPAGE lplpBufStructure = new LANGANDCODEPAGE(lplpBuffer.getValue());
        lplpBufStructure.read();
        StringBuilder hexBuilder = new StringBuilder();
        String languageAsHex = String.format("%04x", lplpBufStructure.wLanguage);
        String codePageAsHex = String.format("%04x", lplpBufStructure.wCodePage);
        hexBuilder.append(languageAsHex);
        hexBuilder.append(codePageAsHex);
        return hexBuilder.toString();
    }

    private boolean ExecuteQuery(Pointer lpData, String lpSubBlock, PointerByReference lplpBuffer, IntByReference puLen) {
        return Version.INSTANCE.VerQueryValue(lpData, lpSubBlock, lplpBuffer, puLen);
    }

    private String getFilePropertyValue(String applicationPath, int fileVersionInfoSize, String translation, String propertyKey) throws Exception {
        IntByReference puLen;
        PointerByReference lplpBuffer;
        Pointer lpData = this.allocateBuffer(fileVersionInfoSize);
        boolean fileInfoStatusSuccess = Version.INSTANCE.GetFileVersionInfo(applicationPath, 0, fileVersionInfoSize, lpData);
        if (!fileInfoStatusSuccess) {
            throw new Exception("Unable to load application information");
        }
        String queryPath = "\\StringFileInfo\\" + translation + "\\" + propertyKey;
        boolean verQuerySuccess = this.ExecuteQuery(lpData, queryPath, lplpBuffer = new PointerByReference(), puLen = new IntByReference());
        if (!verQuerySuccess) {
            throw new Exception("Unable to load application information");
        }
        int descLength = puLen.getValue();
        Pointer pointerToPropertyStringValue = lplpBuffer.getValue();
        char[] charBuffer = pointerToPropertyStringValue.getCharArray(0L, descLength);
        String propertyValue = new String(charBuffer);
        return propertyValue.trim();
    }

    @Override
    public String getDefaultAppDirectory() {
        return LOCATION_WINDOWS;
    }

    @Override
    public ApplicationData extractAppData(File file) throws Exception {
        String absPath = file.getAbsolutePath();
        if (file == null || !file.exists()) {
            throw new FileNotFoundException(absPath);
        }
        Icon icon = this.getSystemIconFor(file);
        IntByReference dwDummy = new IntByReference(0);
        int fileVersionInfoSize = Version.INSTANCE.GetFileVersionInfoSize(absPath, dwDummy);
        String applicationName = FilenameUtils.getBaseName((String)absPath);
        if (fileVersionInfoSize > 0) {
            String translation = this.getTranslation(absPath, fileVersionInfoSize);
            String fileDescription = this.getFilePropertyValue(absPath, fileVersionInfoSize, translation, APPLICATION_PROPERTY_KEY_FILE_DESCRIPTION);
            String productName = this.getFilePropertyValue(absPath, fileVersionInfoSize, translation, APPLICATION_PROPERTY_KEY_PRODUCT_NAME);
            if (!fileDescription.isEmpty()) {
                applicationName = fileDescription;
            } else if (!productName.isEmpty()) {
                applicationName = productName;
            }
        }
        return new ApplicationData(icon, applicationName, absPath);
    }

    @Override
    public String[] getDefaultOpenCommandFor(URL location) {
        return new String[]{"cmd", "/c", "start", location.toString()};
    }
}

