/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.Iterator;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class ArchivedFilesLoader
extends BatchCallTree {
    private Object result;
    private Collection<Long> pixelsID;
    private SecurityContext ctx;

    private void downloadFile(long id) {
        try {
            OmeroDataService os = this.context.getDataService();
            this.result = os.getOriginalFiles(this.ctx, id);
        }
        catch (Exception e) {
            this.context.getLogger().error((Object)this, "Cannot retrieve download the file: " + e.getMessage());
        }
    }

    @Override
    protected void buildTree() {
        Iterator<Long> i = this.pixelsID.iterator();
        String description = "Downloading original files.";
        while (i.hasNext()) {
            Long id;
            final Long pix = id = i.next();
            this.add(new BatchCall(description){

                @Override
                public void doCall() {
                    ArchivedFilesLoader.this.downloadFile(pix);
                }
            });
        }
    }

    @Override
    protected Object getPartialResult() {
        return this.result;
    }

    @Override
    protected Object getResult() {
        return null;
    }

    public ArchivedFilesLoader(SecurityContext ctx, Collection<Long> pixelsID) {
        this.pixelsID = pixelsID;
        this.ctx = ctx;
    }
}

