/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.awt.Point;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import omero.gateway.Gateway;
import omero.gateway.SecurityContext;
import omero.gateway.exception.DataSourceException;
import omero.gateway.facility.RawDataFacility;
import omero.gateway.model.PixelsData;
import omero.gateway.rnd.Plane2D;
import org.openmicroscopy.shoola.env.rnd.roi.PointIteratorObserver;
import org.openmicroscopy.shoola.util.roi.model.ROIShape;

class PointIterator {
    private int sizeZ;
    private int sizeT;
    private int sizeX;
    private int sizeY;
    private int sizeC;
    private PixelsData pixels;
    private RawDataFacility rf;
    private Set<PointIteratorObserver> observers;

    private void notifyIterationStart() {
        for (PointIteratorObserver obs : this.observers) {
            obs.iterationStarted();
        }
    }

    private void notifyIterationEnd() {
        for (PointIteratorObserver obs : this.observers) {
            obs.iterationFinished();
        }
    }

    private void notifyPlaneStart(int z, int w, int t, int pointsCount) {
        for (PointIteratorObserver obs : this.observers) {
            obs.onStartPlane(z, w, t, pointsCount);
        }
    }

    private void notifyValue(double pixelValue, int z, int w, int t, Point loc) {
        for (PointIteratorObserver obs : this.observers) {
            obs.update(pixelValue, z, w, t, loc);
        }
    }

    private void notifyPlaneEnd(int z, int w, int t, int pointsCount) {
        for (PointIteratorObserver obs : this.observers) {
            obs.onEndPlane(z, w, t, pointsCount);
        }
    }

    private boolean isValidPoint(int x, int y) {
        if (x < 0 || x >= this.sizeX) {
            return false;
        }
        return y >= 0 && y < this.sizeY;
    }

    PointIterator(Gateway gw, PixelsData pixels) throws ExecutionException {
        if (gw == null) {
            throw new NullPointerException("No Gateway.");
        }
        this.pixels = pixels;
        this.sizeZ = pixels.getSizeZ();
        this.sizeC = pixels.getSizeC();
        this.sizeT = pixels.getSizeT();
        this.sizeX = pixels.getSizeX();
        this.sizeY = pixels.getSizeY();
        this.observers = new HashSet<PointIteratorObserver>();
        this.rf = gw.getFacility(RawDataFacility.class);
    }

    void register(PointIteratorObserver observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        this.observers.add(observer);
    }

    void remove(PointIteratorObserver observer) {
        if (observer == null) {
            throw new NullPointerException("No observer.");
        }
        this.observers.remove(observer);
    }

    void clearNotificationList() {
        this.observers = new HashSet<PointIteratorObserver>();
    }

    public void iterate(SecurityContext ctx, ROIShape shape, List<Point> points, int w, boolean close) throws DataSourceException {
        if (shape == null) {
            throw new NullPointerException("No shapes.");
        }
        if (w < 0 || w >= this.sizeC) {
            throw new NullPointerException("Channel not valid.");
        }
        this.notifyIterationStart();
        try {
            int z = shape.getZ();
            int t = shape.getT();
            if (z >= 0 && z < this.sizeZ && t >= 0 && t < this.sizeT) {
                this.notifyPlaneStart(z, w, t, points.size());
                Plane2D data = this.rf.getPlane(ctx, this.pixels, z, t, w);
                int length = 0;
                for (Point p : points) {
                    int x1 = p.x;
                    int x2 = p.y;
                    if (!this.isValidPoint(x1, x2)) continue;
                    double value = data.getPixelValue(x1, x2);
                    this.notifyValue(value, z, w, t, p);
                    ++length;
                }
                this.notifyPlaneEnd(z, w, t, length);
            }
        }
        catch (Exception e) {
            throw new DataSourceException(e);
        }
        finally {
            if (close) {
                this.rf.close();
            }
            this.notifyIterationEnd();
        }
    }
}

