/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.rnd.roi;

import java.awt.Point;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openmicroscopy.shoola.env.rnd.roi.AbstractROIShapeStats;

public class ROIShapeStats
extends AbstractROIShapeStats {
    private Map<Point, Double> pixelsValue;

    public Map<Point, Double> getPixelsValue() {
        return this.pixelsValue;
    }

    @Override
    public void onEndPlane(int z, int c, int t, int pointsCount) {
        double sigmaSquare;
        if (pointsCount <= 0) {
            return;
        }
        this.mean = this.sum / (double)pointsCount;
        this.pointsCount = pointsCount;
        if (0 < pointsCount - 1 && (sigmaSquare = (this.sumOfSquares - this.sum * this.sum / (double)pointsCount) / (double)(pointsCount - 1)) > 0.0) {
            this.standardDeviation = Math.sqrt(sigmaSquare);
        }
    }

    @Override
    public void update(double pixelValue, int z, int w, int t, Point loc) {
        this.min = Math.min(pixelValue, this.min);
        this.max = Math.max(pixelValue, this.max);
        this.sum += pixelValue;
        this.sumOfSquares += pixelValue * pixelValue;
        this.pixelsValue.put(loc, new Double(pixelValue));
    }

    @Override
    public void onStartPlane(int z, int w, int t, int pointsCount) {
        this.pixelsValue = new LinkedHashMap<Point, Double>(pointsCount);
    }

    @Override
    public void iterationStarted() {
    }

    @Override
    public void iterationFinished() {
    }
}

