/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import omero.gateway.SecurityContext;
import omero.gateway.model.FileAnnotationData;
import omero.model.OriginalFile;
import org.jdesktop.swingx.JXBusyLabel;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.ProcessException;
import org.openmicroscopy.shoola.env.data.model.ApplicationData;
import org.openmicroscopy.shoola.env.data.model.DownloadActivityParam;
import org.openmicroscopy.shoola.env.data.model.DownloadAndLaunchActivityParam;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.ActivityProcessEvent;
import org.openmicroscopy.shoola.env.ui.ActivityResultPopupMenu;
import org.openmicroscopy.shoola.env.ui.ActivityResultRow;
import org.openmicroscopy.shoola.env.ui.IconManager;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;
import org.openmicroscopy.shoola.env.ui.ViewObjectEvent;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public abstract class ActivityComponent
extends JPanel
implements ActionListener {
    static final String REMOVE_ACTIVITY_PROPERTY = "removeActivity";
    static final String UNREGISTER_ACTIVITY_PROPERTY = "unregisterActivity";
    private static final Dimension SIZE = new Dimension(22, 22);
    private static final int REMOVE = 0;
    private static final int CANCEL = 1;
    private static final int EXCEPTION = 2;
    private static final int ALL_RESULT = 3;
    private static final int ERROR = 4;
    private static final int INFO = 5;
    private static final String MESSAGE = "Message";
    static final String STD_ERR = "stderr";
    static final String STD_OUT = "stdout";
    private JXBusyLabel status;
    private JButton removeButton;
    private JButton cancelButton;
    protected JLabel iconLabel;
    private JComponent statusPane;
    private int buttonIndex;
    private JToolBar toolBar;
    private JButton exceptionButton;
    private ActivityResultPopupMenu errorMenu;
    private ActivityResultPopupMenu infoMenu;
    private Throwable exception;
    protected JLabel type;
    protected JLabel messageLabel;
    protected final Registry registry;
    protected final SecurityContext ctx;
    protected final UserNotifier viewer;
    protected Object result;
    protected UserNotifierLoader loader;
    protected Object errorObject;
    protected Object infoObject;
    private JComponent resultPane;
    protected List<ActivityResultRow> resultButtons;
    private PropertyChangeListener listener;
    private String paneIndex;

    private void open(Object object, Object parameters, JComponent source) {
        File f;
        if (!(object instanceof FileAnnotationData) && !(object instanceof OriginalFile)) {
            return;
        }
        Environment env = (Environment)this.registry.lookup("/env");
        int index = -1;
        long id = -1L;
        Object name = "";
        OriginalFile of = null;
        if (object instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)object;
            if (data.isLoaded()) {
                of = (OriginalFile)data.getContent();
                name = data.getFileName();
            } else {
                id = data.getId();
                index = 1;
                name = "Annotation_" + id;
            }
        } else {
            of = (OriginalFile)object;
            id = of.getId().getValue();
            if (!of.isLoaded()) {
                index = 0;
                name = "File_" + id;
            } else {
                name = of.getName() != null ? of.getName().getValue() : "File_" + id;
            }
        }
        Object path = env.getOmeroFilesHome();
        if (index != -1) {
            f = new File((String)(path = (String)path + File.separator + (String)name));
            if (f.exists()) {
                f.delete();
                f = new File((String)path);
            }
            f.deleteOnExit();
        } else {
            String v = (String)path + File.separator + (String)name;
            File ff = new File(v);
            if (ff.exists()) {
                ff.delete();
            }
            f = new File((String)path);
        }
        DownloadAndLaunchActivityParam activity = index != -1 ? new DownloadAndLaunchActivityParam(id, index, f, null) : new DownloadAndLaunchActivityParam(of, f, null);
        if (parameters instanceof ApplicationData) {
            activity.setApplicationData((ApplicationData)parameters);
        }
        activity.setSource(source);
        this.viewer.notifyActivity(this.ctx, activity);
    }

    private void initComponents(String text, Icon icon) {
        this.exceptionButton = this.createButton("Failure", 2, this);
        this.exceptionButton.setVisible(false);
        this.removeButton = this.createButton("Remove", 0, this);
        this.cancelButton = this.createButton("Cancel", 1, this);
        this.resultButtons = new ArrayList<ActivityResultRow>();
        this.status = new JXBusyLabel(SIZE);
        this.type = UIUtilities.setTextFont(text);
        this.iconLabel = new JLabel();
        this.messageLabel = UIUtilities.setTextFont("", this.iconLabel.getFont().getStyle(), 10);
        this.iconLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        if (icon != null) {
            this.iconLabel.setIcon(icon);
        }
        this.statusPane = this.status;
        this.resultPane = new JPanel();
        this.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
            }
        };
    }

    private void buildGUI() {
        JPanel barPane = new JPanel();
        barPane.setOpaque(false);
        barPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        double[][] size = new double[][]{{-1.0}, {-2.0, -2.0}};
        barPane.setLayout((LayoutManager)new TableLayout((double[][])size));
        barPane.add((Component)this.type, "0, 0, LEFT, CENTER");
        barPane.add((Component)this.messageLabel, "0, 1, CENTER, CENTER");
        double[][] tl = new double[][]{{-2.0, -1.0, -2.0, -2.0}, {-2.0}};
        this.setLayout((LayoutManager)new TableLayout((double[][])tl));
        this.add((Component)this.statusPane, "0, 0");
        JPanel p = UIUtilities.buildComponentPanel(barPane);
        p.setOpaque(false);
        p.setBackground(barPane.getBackground());
        this.add((Component)p, "1, 0");
        this.paneIndex = "2, 0";
        this.add((Component)this.resultPane, this.paneIndex);
        this.add((Component)this.createToolBar(), "3, 0");
    }

    private JComponent createToolBar() {
        this.toolBar = new JToolBar();
        this.toolBar.setOpaque(false);
        this.toolBar.setFloatable(false);
        this.toolBar.setBorder(null);
        this.buttonIndex = 0;
        this.toolBar.add(this.exceptionButton);
        this.toolBar.add(Box.createHorizontalStrut(5));
        this.buttonIndex = 2;
        this.toolBar.add(this.cancelButton);
        JLabel l = new JLabel();
        Font f = l.getFont();
        l.setForeground(UIUtilities.LIGHT_GREY.darker());
        l.setFont(f.deriveFont(f.getStyle(), f.getSize() - 2));
        String s = UIUtilities.formatDefaultDate(null);
        String[] values = s.split(" ");
        if (values.length > 1) {
            Object v = values[1];
            if (values.length > 2) {
                v = (String)v + " " + values[2];
            }
            l.setText((String)v);
            this.toolBar.add(Box.createHorizontalStrut(5));
            this.toolBar.add(l);
            this.toolBar.add(Box.createHorizontalStrut(5));
        }
        return this.toolBar;
    }

    private void reset() {
        SwingUtilities.invokeLater(() -> {
            this.toolBar.remove(this.buttonIndex);
            this.toolBar.add((Component)this.removeButton, this.buttonIndex);
            this.removeButton.setEnabled(true);
            this.exceptionButton.setVisible(false);
            this.status.setBusy(false);
            this.status.setVisible(false);
            this.statusPane = this.iconLabel;
            this.remove(this.statusPane);
            this.add((Component)this.statusPane, "0, 0, CENTER, CENTER");
            this.repaint();
        });
    }

    private Map<String, Object> convertResult(Map<String, Object> m) {
        HashMap<String, Object> objects = new HashMap<String, Object>();
        if (m == null) {
            return objects;
        }
        this.messageLabel.setText("");
        Object v = m.get(MESSAGE);
        if (v != null && v instanceof String) {
            this.messageLabel.setText((String)v);
        }
        m.remove(MESSAGE);
        if (m.containsKey(STD_ERR)) {
            this.errorObject = m.get(STD_ERR);
            m.remove(STD_ERR);
        }
        if (m.containsKey(STD_OUT)) {
            this.infoObject = m.get(STD_OUT);
            m.remove(STD_OUT);
        }
        return m;
    }

    private void showException() {
        if (this.exception == null) {
            return;
        }
        this.viewer.notifyError(this.type.getText(), this.messageLabel.getText(), this.exception);
    }

    private int runAsPlugin() {
        Environment env = (Environment)this.registry.lookup("/env");
        if (env == null) {
            return -1;
        }
        return env.runAsPlugin();
    }

    ActivityComponent(UserNotifier viewer, Registry registry, SecurityContext ctx) {
        if (viewer == null) {
            throw new NullPointerException("No viewer.");
        }
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        this.viewer = viewer;
        this.registry = registry;
        this.ctx = ctx;
    }

    void initialize(String text, Icon icon) {
        this.initComponents(text, icon);
        this.buildGUI();
    }

    JButton createButton(String text, int actionID, ActionListener l) {
        JButton b = UIUtilities.createHyperLinkButton(text);
        b.setActionCommand("" + actionID);
        b.addActionListener(l);
        return b;
    }

    String getFileName(File[] files, String fileName, String original, String dirPath, int index, String extension) {
        String path = dirPath + original;
        boolean exist = false;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getAbsolutePath().equals(path)) continue;
                exist = true;
                break;
            }
        }
        if (!exist) {
            return original;
        }
        if (CommonsLangUtils.isEmpty(fileName)) {
            return original;
        }
        if (CommonsLangUtils.isNotEmpty(extension)) {
            int n = fileName.lastIndexOf(extension);
            String v = fileName.substring(0, n) + "_(" + index + ")" + extension;
            return this.getFileName(files, fileName, v, dirPath, ++index, extension);
        }
        int lastDot = fileName.lastIndexOf(".");
        if (lastDot != -1) {
            extension = fileName.substring(lastDot, fileName.length());
            String v = fileName.substring(0, lastDot) + "_(" + index + ")" + extension;
            return this.getFileName(files, fileName, v, dirPath, ++index, null);
        }
        return original;
    }

    public void onActivityCancelled() {
        this.reset();
        this.firePropertyChange(UNREGISTER_ACTIVITY_PROPERTY, null, this);
        this.notifyActivityCancelled();
        EventBus bus = this.registry.getEventBus();
        bus.post(new ActivityProcessEvent(this, false));
    }

    public void onCallBackSet() {
        this.cancelButton.setEnabled(true);
    }

    public void startActivity() {
        SwingUtilities.invokeLater(() -> this.status.setBusy(true));
    }

    boolean canPlotResult(Object object) {
        FileAnnotationData fa;
        if (object instanceof FileAnnotationData && (fa = (FileAnnotationData)object).isLoaded()) {
            return fa.getFileName().endsWith(".csv");
        }
        return false;
    }

    void download(String text, Object object, File folder, final boolean deleteWhenFinished) {
        if (!(object instanceof FileAnnotationData) && !(object instanceof OriginalFile)) {
            return;
        }
        int index = -1;
        if (text == null) {
            text = "";
        }
        Object name = "";
        String description = "";
        long dataID = -1L;
        OriginalFile of = null;
        FileAnnotationData fa = null;
        if (object instanceof FileAnnotationData) {
            fa = (FileAnnotationData)object;
            if (fa.isLoaded()) {
                name = fa.getFileName();
                description = fa.getDescription();
                of = (OriginalFile)fa.getContent();
            } else {
                of = null;
                dataID = fa.getId();
                index = 1;
                if (text.length() == 0) {
                    text = "Annotation";
                }
                name = text + "_" + dataID;
            }
        } else {
            of = (OriginalFile)object;
            if (!of.isLoaded()) {
                dataID = of.getId().getValue();
                index = 0;
                if (text.length() == 0) {
                    text = "File";
                }
                name = text + "_" + dataID;
                of = null;
            }
        }
        final OriginalFile original = of;
        final int type = index;
        final String desc = description;
        final long id = dataID;
        if (folder != null) {
            if (original == null && type == -1) {
                return;
            }
            IconManager icons = IconManager.getInstance(this.registry);
            DownloadActivityParam activity = original != null ? new DownloadActivityParam(original, folder, icons.getIcon(17)) : new DownloadActivityParam(id, type, folder, icons.getIcon(17));
            activity.setLegend(desc);
            activity.setUIRegister(true);
            if (fa != null && deleteWhenFinished) {
                activity.setToDelete(fa);
            }
            activity.setOverwrite(true);
            this.viewer.notifyActivity(this.ctx, activity);
            return;
        }
        JFrame f = this.registry.getTaskBar().getFrame();
        FileChooser chooser = new FileChooser(f, 1, "Download", "Select where to download the file.", null, true, true);
        IconManager icons = IconManager.getInstance(this.registry);
        chooser.setTitleIcon(icons.getIcon(18));
        chooser.setSelectedFileFull((String)name);
        chooser.setApproveButtonText("Download");
        final FileAnnotationData anno = fa;
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if ("approveSelection".equals(name)) {
                    File[] files = (File[])evt.getNewValue();
                    File folder = files[0];
                    if (original == null && type == -1) {
                        return;
                    }
                    IconManager icons = IconManager.getInstance(ActivityComponent.this.registry);
                    DownloadActivityParam activity = original != null ? new DownloadActivityParam(original, folder, icons.getIcon(17)) : new DownloadActivityParam(id, type, folder, icons.getIcon(17));
                    activity.setLegend(desc);
                    if (anno != null && deleteWhenFinished) {
                        activity.setToDelete(anno);
                    }
                    ActivityComponent.this.viewer.notifyActivity(ActivityComponent.this.ctx, activity);
                }
            }
        });
        chooser.centerDialog();
    }

    void download(String text, Object object) {
        this.download(text, object, null, false);
    }

    void view(Object object, JComponent source) {
        if (object instanceof FileAnnotationData || object instanceof OriginalFile) {
            this.open(object, null, source);
        } else if (object instanceof File) {
            this.viewer.openApplication(null, ((File)object).getAbsolutePath());
            if (source != null) {
                source.setEnabled(true);
            }
        } else {
            EventBus bus = this.registry.getEventBus();
            ViewObjectEvent evt = new ViewObjectEvent(this.ctx, object, source);
            evt.setPlugin(this.runAsPlugin());
            bus.post(evt);
        }
    }

    void browse(Object object, JComponent source) {
        EventBus bus = this.registry.getEventBus();
        ViewObjectEvent evt = new ViewObjectEvent(this.ctx, object, source);
        evt.setBrowseObject(true);
        bus.post(evt);
    }

    boolean hasInfo() {
        return this.infoObject != null;
    }

    boolean hasError() {
        return this.errorObject != null;
    }

    boolean isOngoingActivity() {
        return this.status.isBusy();
    }

    public void notifyError(String text, String message, Throwable ex) {
        Throwable cause;
        this.reset();
        int status = -1;
        if (ex != null && (cause = ex.getCause()) instanceof ProcessException && (status = ((ProcessException)cause).getStatus()) == 0) {
            this.messageLabel.setText("No processor available. Please try later.");
        }
        if (text != null) {
            this.type.setText(text);
            if (message != null) {
                this.type.setToolTipText(message);
            }
        }
        this.exception = ex;
        if (this.exception != null && status != 0) {
            this.exceptionButton.setVisible(true);
            this.exceptionButton.setToolTipText(UIUtilities.formatExceptionForToolTip(ex));
        }
        this.firePropertyChange(UNREGISTER_ACTIVITY_PROPERTY, null, this);
        this.notifyActivityError();
        EventBus bus = this.registry.getEventBus();
        bus.post(new ActivityProcessEvent(this, true));
    }

    private void showMenu(JComponent src, int index, int x, int y) {
        switch (index) {
            case 4: {
                if (this.errorMenu == null) {
                    this.errorMenu = new ActivityResultPopupMenu(this.errorObject, this);
                }
                this.errorMenu.show(src, x, y);
                break;
            }
            case 5: {
                if (this.infoMenu == null) {
                    this.infoMenu = new ActivityResultPopupMenu(this.infoObject, this);
                }
                this.infoMenu.show(src, x, y);
            }
        }
    }

    public void endActivity(Object result) {
        this.result = result;
        boolean busy = this.status.isBusy();
        this.reset();
        if (result instanceof Map) {
            Map<String, Object> m = this.convertResult((Map)result);
            int size = m.size();
            this.result = m;
            this.remove(this.resultPane);
            Color c = this.getBackground();
            if (size == 0) {
                JButton button;
                JToolBar row = new JToolBar();
                row.setOpaque(false);
                row.setFloatable(false);
                row.setBorder(null);
                row.setBackground(c);
                if (this.errorObject != null) {
                    button = this.createButton("Error", 4, this);
                    button.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            ActivityComponent.this.showMenu((JComponent)e.getSource(), 4, e.getX(), e.getY());
                        }
                    });
                    row.add(button);
                }
                if (this.infoObject != null) {
                    button = this.createButton("Info", 5, this);
                    button.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            ActivityComponent.this.showMenu((JComponent)e.getSource(), 5, e.getX(), e.getY());
                        }
                    });
                    row.add(button);
                }
                this.add((Component)row, this.paneIndex);
            } else {
                Iterator<Map.Entry<String, Object>> i = m.entrySet().iterator();
                ActivityResultRow row = null;
                JPanel content = new JPanel();
                content.setLayout(new BoxLayout(content, 1));
                content.setBackground(c);
                int index = 0;
                int max = 2;
                JButton moreButton = null;
                while (i.hasNext()) {
                    Map.Entry<String, Object> entry = i.next();
                    this.result = entry.getValue();
                    row = new ActivityResultRow(entry.getKey(), entry.getValue(), this);
                    row.setBackground(c);
                    row.addPropertyChangeListener(this.listener);
                    this.resultButtons.add(row);
                    if (index < max) {
                        content.add(row);
                    } else if (moreButton == null) {
                        moreButton = this.createButton(m.size() - max + " more", 3, this);
                        content.add(moreButton);
                    }
                    ++index;
                }
                if (m.size() == 1) {
                    this.add(row, this.paneIndex);
                } else {
                    this.add((Component)content, this.paneIndex);
                }
                this.resultPane = content;
            }
            this.repaint();
        }
        this.firePropertyChange(UNREGISTER_ACTIVITY_PROPERTY, null, this);
        this.notifyActivityEnd();
        EventBus bus = this.registry.getEventBus();
        bus.post(new ActivityProcessEvent(this, busy));
    }

    public JComponent getActivityType() {
        return new JLabel(this.type.getText());
    }

    protected abstract void notifyActivityCancelled();

    protected abstract void notifyActivityEnd();

    protected abstract void notifyActivityError();

    protected abstract UserNotifierLoader createLoader();

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.firePropertyChange(REMOVE_ACTIVITY_PROPERTY, null, this);
                break;
            }
            case 1: {
                this.onActivityCancelled();
                if (this.cancelButton != null) {
                    this.cancelButton.setEnabled(false);
                }
                if (this.loader == null) break;
                this.loader.cancel();
                break;
            }
            case 2: {
                this.showException();
                break;
            }
            case 3: {
                Iterator<ActivityResultRow> i = this.resultButtons.iterator();
                JPanel content = new JPanel();
                content.setBackground(this.getBackground());
                content.setLayout(new BoxLayout(content, 1));
                while (i.hasNext()) {
                    content.add(i.next());
                }
                this.remove(this.resultPane);
                this.add((Component)content, this.paneIndex);
                this.resultPane = content;
                this.validate();
                this.repaint();
            }
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.resultPane != null) {
            this.resultPane.setBackground(color);
        }
        if (this.removeButton != null) {
            this.removeButton.setBackground(color);
        }
        if (this.cancelButton != null) {
            this.cancelButton.setBackground(color);
        }
        if (this.exceptionButton != null) {
            this.exceptionButton.setBackground(color);
        }
    }
}

