/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.ui;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import omero.gateway.SecurityContext;
import omero.gateway.model.FileAnnotationData;
import org.apache.commons.io.FileUtils;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.data.model.DownloadAndZipParam;
import org.openmicroscopy.shoola.env.ui.ActivityComponent;
import org.openmicroscopy.shoola.env.ui.FilesLoader;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.env.ui.UserNotifierLoader;

public class DownloadAndZipActivity
extends ActivityComponent {
    private static final String DESCRIPTION_CANCEL = "Download cancelled";
    private static final String DESCRIPTION = "Zip created";
    private DownloadAndZipParam parameters;
    private File zipFolder;

    public DownloadAndZipActivity(UserNotifier viewer, Registry registry, SecurityContext ctx, DownloadAndZipParam parameters) {
        super(viewer, registry, ctx);
        File parent;
        File f;
        if (parameters == null) {
            throw new IllegalArgumentException("No parameters");
        }
        this.parameters = parameters;
        this.initialize("Download", parameters.getIcon());
        File folder = parameters.getFolder();
        if (!folder.exists()) {
            folder.mkdir();
            this.zipFolder = folder;
        } else if (folder.isFile() && (f = new File(parent = folder.getParentFile(), folder.getName() + "_zip")).mkdir()) {
            this.zipFolder = f;
        }
    }

    @Override
    protected UserNotifierLoader createLoader() {
        List<FileAnnotationData> files = this.parameters.getFiles();
        Iterator<FileAnnotationData> i = files.iterator();
        HashMap<FileAnnotationData, File> toLoad = new HashMap<FileAnnotationData, File>();
        while (i.hasNext()) {
            FileAnnotationData fa = i.next();
            toLoad.put(fa, new File(this.zipFolder, fa.getFileName()));
        }
        this.loader = new FilesLoader(this.viewer, this.registry, this.ctx, toLoad, this);
        return this.loader;
    }

    @Override
    protected void notifyActivityEnd() {
        try {
            this.messageLabel.setText(this.zipFolder.getAbsolutePath());
            FileUtils.deleteDirectory((File)this.zipFolder);
        }
        catch (Exception e) {
            this.registry.getLogger().error((Object)this, "Error deleting folder:" + e.getMessage());
        }
        this.type.setText(DESCRIPTION);
    }

    @Override
    protected void notifyActivityCancelled() {
        this.type.setText(DESCRIPTION_CANCEL);
    }

    @Override
    protected void notifyActivityError() {
    }
}

