/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur;

import org.openmicroscopy.shoola.util.concur.ControlFlowObserver;

public class Semaphore {
    private int count;
    static final int LOCK_ACQUIRED = 1;
    private ControlFlowObserver flowObs;

    private boolean decreaseCount(long timeout) throws InterruptedException {
        if (0 < this.count) {
            --this.count;
            return true;
        }
        if (0L <= timeout) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException ie) {
                this.notify();
                throw ie;
            }
        }
        return false;
    }

    public Semaphore(int initialCount) {
        this.count = initialCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.flowObs != null) {
                this.flowObs.update(1);
            }
            while (!this.decreaseCount(0L)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean down(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.flowObs != null) {
                this.flowObs.update(1);
            }
            if (this.decreaseCount(-1L)) {
                return true;
            }
            if (timeout <= 0L) {
                return false;
            }
            long start = System.currentTimeMillis();
            long delta = timeout;
            do {
                if (!this.decreaseCount(delta)) continue;
                return true;
            } while ((delta = start + timeout - System.currentTimeMillis()) > 0L);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up() {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.flowObs != null) {
                this.flowObs.update(1);
            }
            ++this.count;
            this.notify();
        }
    }

    synchronized int getCount() {
        return this.count;
    }

    void register(ControlFlowObserver obs) {
        this.flowObs = obs;
    }
}

