/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.concur.tasks;

import org.openmicroscopy.shoola.util.concur.ControlFlowObserver;
import org.openmicroscopy.shoola.util.concur.tasks.ExecException;
import org.openmicroscopy.shoola.util.concur.tasks.ExecHandle;

public class Future
extends ExecHandle {
    static final int WAITING_FOR_RESULT = 0;
    static final int HAS_RESULT = 1;
    static final int HAS_EXCEPTION = 2;
    private Object result = null;
    private ExecException failureWrapper = null;
    private int state = 0;
    static final int LOCK_ACQUIRED = 100;
    private ControlFlowObserver flowObs;

    private void set(Object result, Throwable t) {
        if (this.state != 0) {
            throw new Error("Can't reuse a future.");
        }
        this.result = result;
        if (t != null) {
            this.failureWrapper = new ExecException(t);
        }
        this.notifyAll();
    }

    Future() {
    }

    synchronized void setResult(Object r) {
        if (this.flowObs != null) {
            this.flowObs.update(100);
        }
        this.set(r, null);
        this.state = 1;
    }

    synchronized void setException(Throwable t) {
        if (t == null) {
            t = new Error("Future.setException(null) is not a valid call.(Bug in the execution workflow code.)");
        }
        if (this.flowObs != null) {
            this.flowObs.update(100);
        }
        this.set(null, t);
        this.state = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResult() throws ExecException, InterruptedException {
        Future future = this;
        synchronized (future) {
            if (this.flowObs != null) {
                this.flowObs.update(100);
            }
            while (this.state == 0) {
                this.wait();
            }
            if (this.state == 2) {
                throw this.failureWrapper;
            }
            return this.result;
        }
    }

    public Object getResult(long msec) throws ExecException, InterruptedException {
        throw new NoSuchMethodError();
    }

    void register(ControlFlowObserver obs) {
        this.flowObs = obs;
    }

    synchronized int getState() {
        return this.state;
    }
}

