/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.openmicroscopy.shoola.util.ui.PaintPot;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.colourpicker.LookupTableIconUtil;

class PaintPotUI
extends PaintPot
implements PropertyChangeListener {
    static final String COLOUR_CHANGED_PROPERTY = "colourChanged";
    public static final String LUT_PROPERTY = "lut";
    private JComponent control;

    PaintPotUI(Color col, String lut, JComponent c) {
        super(col);
        if (c == null) {
            throw new NullPointerException("No control.");
        }
        this.image = StringUtils.isBlank((CharSequence)lut) ? null : LookupTableIconUtil.getLUTIconImage(lut);
        this.control = c;
        this.control.addPropertyChangeListener(COLOUR_CHANGED_PROPERTY, this);
        this.control.addPropertyChangeListener(LUT_PROPERTY, this);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.render(g);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals(COLOUR_CHANGED_PROPERTY)) {
            this.colour = (Color)event.getNewValue();
            this.image = null;
        } else if (event.getPropertyName().equals(LUT_PROPERTY)) {
            String lut = (String)event.getNewValue();
            this.image = LookupTableIconUtil.getLUTIconImage(lut);
            this.colour = UIUtilities.BACKGROUND_COLOR;
        }
        this.invalidate();
        this.repaint();
    }
}

