/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.List;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SearchContext {
    public static final int CURRENT_USER = 0;
    public static final int OTHERS = 1;
    public static final int IMAGES = 0;
    public static final int DATASETS = 1;
    public static final int PROJECTS = 2;
    public static final int SCREENS = 3;
    public static final int PLATES = 4;
    public static final int WELLS = 5;
    public static final int TEXT_ANNOTATION = 6;
    public static final int TAGS = 7;
    public static final int TAG_SETS = 8;
    public static final int NAME = 9;
    public static final int FILE_ANNOTATION = 10;
    public static final int URL_ANNOTATION = 11;
    public static final int DESCRIPTION = 12;
    public static final int CUSTOMIZED = 13;
    public static final int ANNOTATION = 14;
    public static final int ANY_DATE = 0;
    public static final int LAST_TWO_WEEKS = 1;
    public static final int LAST_MONTH = 2;
    public static final int LAST_TWO_MONTHS = 3;
    public static final int ONE_YEAR = 4;
    public static final int RANGE = 5;
    public static final int MAX = 5;
    public static final int LEVEL_ONE = 0;
    public static final int LEVEL_TWO = 1;
    public static final int LEVEL_THREE = 2;
    public static final int LEVEL_FOUR = 3;
    public static final int MAX_RESULTS = 3;
    public static final int LEVEL_ONE_VALUE = 50;
    public static final int LEVEL_TWO_VALUE = 100;
    public static final int LEVEL_THREE_VALUE = 250;
    public static final int LEVEL_FOUR_VALUE = 500;
    public static final int ALL_FORMATS = 0;
    public static final int HTML = 1;
    public static final int PDF = 2;
    public static final int EXCEL = 3;
    public static final int POWER_POINT = 4;
    public static final int WORD = 5;
    public static final int XML = 6;
    public static final int TEXT = 7;
    public static final int MAX_FORMAT = 8;
    private String query;
    private List<Integer> context;
    private List<Integer> type;
    private long selectedOwner = -1L;
    private List<String> excludedOwners;
    private List<String> excludedAnnotators;
    private Timestamp startTime;
    private Timestamp endTime;
    private List<Integer> ownerSearchContext;
    private List<Integer> annotatorSearchContext;
    private boolean caseSensitive;
    private int numberOfResults;
    private int timeType;
    private int dateIndex;
    private int attachmentType;
    private long selectedGroup = Integer.MAX_VALUE;

    public SearchContext(String query, List<Integer> context) {
        this.query = query;
        this.context = context;
        this.timeType = -1;
        this.attachmentType = 0;
    }

    void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    void setOwnerSearchContext(List<Integer> context) {
        this.ownerSearchContext = context;
    }

    void setAnnotatorSearchContext(List<Integer> context) {
        this.annotatorSearchContext = context;
    }

    public void setTime(Timestamp startTime, Timestamp endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
        if (startTime != null && endTime != null) {
            this.dateIndex = 5;
        }
    }

    public void setSelectedOwner(long user) {
        this.selectedOwner = user;
    }

    void setTime(int index) {
        GregorianCalendar gc = new GregorianCalendar();
        this.endTime = UIUtilities.getDefaultTimestamp();
        switch (index) {
            case 0: {
                this.setTime(null, null);
                break;
            }
            case 1: {
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 1209600000L);
                break;
            }
            case 2: {
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 2592000000L);
                break;
            }
            case 3: {
                gc = new GregorianCalendar(gc.get(1), gc.get(2), gc.get(5), 23, 59, 0);
                this.startTime = new Timestamp(gc.getTime().getTime() - 5184000000L);
                break;
            }
            case 4: {
                gc = new GregorianCalendar(gc.get(1), 0, 1, 0, 0, 0);
                this.startTime = new Timestamp(gc.getTime().getTime());
            }
        }
        this.dateIndex = index;
    }

    public void setTimeType(int timeType) {
        this.timeType = timeType;
    }

    void setExcludedOwners(List<String> users) {
        this.excludedOwners = users;
    }

    void setExcludedAnnotators(List<String> users) {
        this.excludedAnnotators = users;
    }

    void setAttachmentType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.attachmentType = type;
                break;
            }
            default: {
                this.attachmentType = 0;
            }
        }
    }

    int getAttachmentType() {
        return this.attachmentType;
    }

    public int getDateIndex() {
        return this.dateIndex;
    }

    public int getTimeType() {
        return this.timeType;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Integer> getContext() {
        return this.context;
    }

    public long getSelectedOwner() {
        return this.selectedOwner;
    }

    public List<String> getExcludedOwners() {
        return this.excludedOwners;
    }

    public List<String> getExcludedAnnotators() {
        return this.excludedAnnotators;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public List<Integer> getOwnerSearchContext() {
        return this.ownerSearchContext;
    }

    public List<Integer> getAnnotatorSearchContext() {
        return this.annotatorSearchContext;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setType(List<Integer> type) {
        this.type = type;
    }

    public List<Integer> getType() {
        return this.type;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public void setNumberOfResults(int results) {
        this.numberOfResults = results;
    }

    public long getSelectedGroup() {
        return this.selectedGroup;
    }

    public void setSelectedGroup(long selectedGroup) {
        this.selectedGroup = selectedGroup;
    }
}

