/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.tpane;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import org.openmicroscopy.shoola.util.ui.IconManager;
import org.openmicroscopy.shoola.util.ui.tpane.TinyObserver;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;

public class CloseButton
extends JButton
implements TinyObserver,
PropertyChangeListener,
ActionListener {
    static final String CLOSE_TOOLTIP = "Close";
    private TinyPane model;

    CloseButton(TinyPane model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setOpaque(false);
        this.setFocusPainted(false);
        this.setRolloverEnabled(true);
        this.model = model;
    }

    @Override
    public void attach() {
        this.addActionListener(this);
        this.model.addPropertyChangeListener("closedPane", this);
        this.propertyChange(null);
    }

    @Override
    public void detach() {
        this.model.removePropertyChangeListener("closedPane", this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (!this.model.isClosed()) {
            IconManager icons = IconManager.getInstance();
            this.setIcon(icons.getIcon(35));
            this.setRolloverIcon(icons.getIcon(36));
            this.setToolTipText(CLOSE_TOOLTIP);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        boolean b = !this.model.isClosed();
        this.model.setClosed(b);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void requestFocus() {
    }
}

