/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import java.awt.AWTEvent;
import java.awt.Color;

public class PointToolOptions
implements PlugIn,
DialogListener {
    boolean multipointTool;

    public void run(String arg) {
        this.showDialog();
    }

    void showDialog() {
        this.multipointTool = IJ.getToolName().equals("multipoint");
        Color sc = Roi.getColor();
        String sname = Colors.getColorName(sc, "Yellow");
        Color cc = PointRoi.getDefaultCrossColor();
        String cname = Colors.getColorName(cc, "None");
        String markerSize = PointRoi.getDefaultMarkerSize();
        GenericDialog gd = new GenericDialog("Point Tool");
        gd.setInsets(5, 0, 2);
        gd.addChoice("Selection color:", Colors.getColors(new String[0]), sname);
        gd.setInsets(0, 0, 2);
        gd.addChoice("Cross color:", Colors.getColors("None"), cname);
        gd.addChoice("Marker size:", PointRoi.sizes, markerSize);
        if (!this.multipointTool) {
            gd.addNumericField("Mark width:", Analyzer.markWidth, 0, 2, "pixels");
            gd.addCheckbox("Auto-measure", Prefs.pointAutoMeasure);
            gd.addCheckbox("Auto-next slice", Prefs.pointAutoNextSlice);
            gd.addCheckbox("Add to ROI Manager", Prefs.pointAddToManager);
        }
        gd.addCheckbox("Label points", !Prefs.noPointLabels);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            // empty if block
        }
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        ImagePlus imp;
        boolean noPointLabels;
        String crossColor;
        Color cc;
        boolean redraw = false;
        String selectionColor = gd.getNextChoice();
        Color sc = Colors.getColor(selectionColor, Color.yellow);
        if (sc != Roi.getColor()) {
            Roi.setColor(sc);
            redraw = true;
            Toolbar.getInstance().repaint();
        }
        if ((cc = Colors.getColor(crossColor = gd.getNextChoice(), null)) != PointRoi.getDefaultCrossColor()) {
            redraw = true;
        }
        PointRoi.setDefaultCrossColor(cc);
        String markerSize = gd.getNextChoice();
        if (!markerSize.equals(PointRoi.getDefaultMarkerSize())) {
            PointRoi.setDefaultMarkerSize(markerSize);
            redraw = true;
        }
        if (!this.multipointTool) {
            int width = (int)gd.getNextNumber();
            if (width < 0) {
                width = 0;
            }
            Analyzer.markWidth = width;
            Prefs.pointAutoMeasure = gd.getNextBoolean();
            Prefs.pointAutoNextSlice = gd.getNextBoolean();
            Prefs.pointAddToManager = gd.getNextBoolean();
            if (Prefs.pointAutoNextSlice && !Prefs.pointAddToManager) {
                Prefs.pointAutoMeasure = true;
            }
        }
        boolean bl = noPointLabels = !gd.getNextBoolean();
        if (noPointLabels != Prefs.noPointLabels) {
            redraw = true;
        }
        Prefs.noPointLabels = noPointLabels;
        if (redraw && (imp = WindowManager.getCurrentImage()) != null) {
            imp.draw();
        }
        return true;
    }
}

