/*
 * Decompiled with CFR 0.152.
 */
package ij.macro;

import ij.IJ;
import ij.ImageJ;
import ij.WindowManager;
import ij.plugin.frame.Editor;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class FunctionFinder
implements TextListener,
WindowListener,
KeyListener,
ItemListener,
ActionListener {
    private Dialog dialog;
    private TextField prompt;
    private List functions;
    private Button insertButton;
    private Button infoButton;
    private Button closeButton;
    private String[] commands;
    private Editor editor;

    public FunctionFinder(Editor editor) {
        this.editor = editor;
        String exists = IJ.runMacro("return File.exists(getDirectory('macros')+'functions.html');");
        if (exists == "0") {
            String installLocalMacroFunctionsFile = "functions = File.openUrlAsString('http://imagej.nih.gov/ij/developer/macro/functions.html');\nf = File.open(getDirectory('macros')+'functions.html');\nprint (f, functions);\nFile.close(f);";
            try {
                IJ.runMacro(installLocalMacroFunctionsFile);
            }
            catch (Throwable e) {
                IJ.error("Problem downloading functions.html");
                return;
            }
        }
        String f = IJ.runMacro("return File.openAsString(getDirectory('macros')+'functions.html');");
        String[] l = f.split("\n");
        this.commands = new String[l.length];
        int c = 0;
        for (int i = 0; i < l.length; ++i) {
            String line = l[i];
            if (!line.startsWith("<b>")) continue;
            this.commands[c] = line.substring(line.indexOf("<b>") + 3, line.indexOf("</b>"));
            ++c;
        }
        if (c == 0) {
            IJ.error("ImageJ/macros/functions.html is corrupted");
            return;
        }
        ImageJ imageJ = IJ.getInstance();
        this.dialog = new Dialog((Frame)imageJ, "Built-in Functions");
        this.dialog.setLayout(new BorderLayout());
        this.dialog.addWindowListener(this);
        Panel northPanel = new Panel();
        this.prompt = new TextField("", 32);
        this.prompt.addTextListener(this);
        this.prompt.addKeyListener(this);
        northPanel.add(this.prompt);
        this.dialog.add((Component)northPanel, "North");
        this.functions = new List(12);
        this.functions.addKeyListener(this);
        this.populateList("");
        this.dialog.add((Component)this.functions, "Center");
        Panel buttonPanel = new Panel();
        this.insertButton = new Button("Insert");
        this.insertButton.addActionListener(this);
        buttonPanel.add(this.insertButton);
        this.infoButton = new Button("Info");
        this.infoButton.addActionListener(this);
        buttonPanel.add(this.infoButton);
        this.closeButton = new Button("Close");
        this.closeButton.addActionListener(this);
        buttonPanel.add(this.closeButton);
        this.dialog.add((Component)buttonPanel, "South");
        this.dialog.pack();
        Frame frame = WindowManager.getFrontWindow();
        if (frame == null) {
            return;
        }
        Point posi = frame.getLocationOnScreen();
        int initialX = (int)posi.getX() + 38;
        int initialY = (int)posi.getY() + 84;
        this.dialog.setLocation(initialX, initialY);
        this.dialog.setVisible(true);
        this.dialog.toFront();
    }

    public FunctionFinder() {
        this(null);
    }

    public void populateList(String matchingSubstring) {
        String substring = matchingSubstring.toLowerCase();
        this.functions.removeAll();
        try {
            for (int i = 0; i < this.commands.length; ++i) {
                String lowerCommandName;
                String commandName = this.commands[i];
                if (commandName.length() == 0 || (lowerCommandName = commandName.toLowerCase()).indexOf(substring) < 0) continue;
                this.functions.add(this.commands[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void edPaste(String arg) {
        Frame frame = this.editor;
        if (frame != null && !frame.isVisible()) {
            frame = null;
        }
        if (frame == null && !((frame = WindowManager.getFrontWindow()) instanceof Editor)) {
            return;
        }
        try {
            TextArea ta = ((Editor)frame).getTextArea();
            int start = ta.getSelectionStart();
            int end = ta.getSelectionEnd();
            try {
                ta.replaceRange(arg.substring(0, arg.length()), start, end);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (IJ.isMacOSX()) {
                ta.setCaretPosition(start + arg.length());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        this.populateList(this.prompt.getText());
    }

    protected void runFromLabel(String listLabel) {
        this.edPaste(listLabel);
        this.dialog.dispose();
    }

    public void close() {
        this.dialog.dispose();
    }

    public void keyPressed(KeyEvent ke) {
        String selected;
        int key = ke.getKeyCode();
        int items = this.functions.getItemCount();
        Object source = ke.getSource();
        if (source == this.prompt) {
            if (key == 10) {
                if (1 == items) {
                    String selected2 = this.functions.getItem(0);
                    this.edPaste(selected2);
                }
            } else if (key == 38) {
                this.functions.requestFocus();
                if (items > 0) {
                    this.functions.select(this.functions.getItemCount() - 1);
                }
            } else if (key == 27) {
                this.dialog.dispose();
            } else if (key == 40) {
                this.functions.requestFocus();
                if (items > 0) {
                    this.functions.select(0);
                }
            }
        } else if (source == this.functions && key == 10 && (selected = this.functions.getSelectedItem()) != null) {
            this.edPaste(selected);
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void textValueChanged(TextEvent te) {
        this.populateList(this.prompt.getText());
    }

    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.insertButton) {
            int index = this.functions.getSelectedIndex();
            if (index >= 0) {
                String selected = this.functions.getItem(index);
                this.edPaste(selected);
            }
        } else if (b == this.infoButton) {
            String url = "http://imagej.nih.gov/ij/developer/macro/functions.html";
            int index = this.functions.getSelectedIndex();
            if (index >= 0) {
                String selected = this.functions.getItem(index);
                int index2 = selected.indexOf("(");
                if (index2 == -1) {
                    index2 = selected.length();
                }
                url = url + "#" + selected.substring(0, index2);
            }
            IJ.runPlugIn("ij.plugin.BrowserLauncher", url);
        } else if (b == this.closeButton) {
            this.dialog.dispose();
        }
    }

    public void windowClosing(WindowEvent e) {
        this.dialog.dispose();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }
}

