/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.env.config.Registry;

public class Colors {
    public static final int TITLE_BAR_HIGHLIGHT = 0;
    public static final int TITLE_BAR = 1;
    private static final int TITLE_BAR_UNMODIFIED = 2;
    private static final int TITLE_BAR_PRIMARY = 3;
    private static final int TITLE_BAR_HIGHLIGHT_PRIMARY = 4;
    public static final int TITLE_BAR_HIGHLIGHT_SECONDARY = 5;
    private static final Color COLOR_TITLE_BAR = new Color(189, 210, 230);
    private static final Color COLOR_TITLE_BAR_HIGHLIGHT_BAR = new Color(58, 116, 215);
    private static Colors singleton;
    private Map<Integer, Color> colorsMap;
    private Registry registry;

    private Colors(Registry registry) {
        if (registry == null) {
            throw new NullPointerException("No registry.");
        }
        this.registry = registry;
        this.colorsMap = new HashMap<Integer, Color>();
        this.initializeColors();
    }

    private void initializeColors() {
        Color c = (Color)this.registry.lookup("/resources/colors/TitleBarHighlight");
        if (c == null) {
            c = COLOR_TITLE_BAR_HIGHLIGHT_BAR;
        }
        this.colorsMap.put(0, c);
        this.colorsMap.put(4, c.darker().darker());
        c = (Color)this.registry.lookup("/resources/colors/TitleBar");
        if (c == null) {
            c = COLOR_TITLE_BAR;
        }
        this.colorsMap.put(1, c);
        this.colorsMap.put(3, c.darker().darker());
        c = (Color)this.registry.lookup("/resources/colors/TitleBarUnmodified");
        this.colorsMap.put(2, c);
        c = (Color)this.registry.lookup("/resources/colors/TitleBarHighlightSecondary");
        if (c == null) {
            c = COLOR_TITLE_BAR_HIGHLIGHT_BAR;
        }
        this.colorsMap.put(5, c);
    }

    public static Colors getInstance() {
        if (singleton == null) {
            singleton = new Colors(DataBrowserAgent.getRegistry());
        }
        return singleton;
    }

    public Color getColor(int id) {
        if (id < 0 || this.colorsMap.size() <= id) {
            this.registry.getLogger().error((Object)this, "color id out of range: " + id + ".");
            return null;
        }
        return this.colorsMap.get(id);
    }

    public Color getDeselectedHighLight(ImageDisplay node) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        Color c = node.getHighlight();
        if (c == null) {
            return null;
        }
        if (c.equals(this.getColor(0)) || c.equals(this.getColor(2)) || c.equals(this.getColor(4))) {
            c = null;
        }
        return c;
    }

    public Color getSelectedHighLight(ImageDisplay node, boolean primary) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        Color c = node.getHighlight();
        if (c == null || c.equals(this.getColor(2)) || c.equals(this.getColor(4)) || c.equals(this.getColor(0))) {
            c = primary ? this.getColor(4) : this.getColor(0);
        }
        return c;
    }

    public Color getUnmodifiedHighLight(ImageDisplay node) {
        if (node == null) {
            return this.getColor(1);
        }
        if (node.getParentDisplay() == null) {
            return this.getColor(1);
        }
        return this.getColor(2);
    }
}

