/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Iterator;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.actions.DataBrowserAction;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ManageRndSettingsAction
extends DataBrowserAction
implements PropertyChangeListener {
    public static final int COPY = 0;
    public static final int PASTE = 1;
    public static final int RESET = 2;
    public static final int SET_MIN_MAX = 3;
    public static final int SET_OWNER = 4;
    private static final String NAME_COPY = "Copy";
    private static final String DESCRIPTION_COPY = "Copy the rendering settings.";
    private static final String NAME_PASTE = "Paste and Save";
    private static final String DESCRIPTION_PASTE = "Paste and Save the rendering settings.";
    private static final String NAME_RESET = "Set Imported and Save";
    private static final String DESCRIPTION_RESET = "Reset and Save the rendering settings created while importing.";
    private static final String NAME_SET_MIN_MAX = "Set Min/Max";
    private static final String DESCRIPTION_SET_MIN_MAX = "Set the Pixels Intensity interval to min/max for all channels.";
    private static final String NAME_SET_OWNER = "Set Owner's and Save";
    private static final String DESCRIPTION_SET_OWNER = "Reset to the Owner's rendering settings and save.";
    private IconManager icons;
    private int index;

    private void checkIndex(int value) {
        switch (value) {
            case 0: {
                this.putValue("Name", NAME_COPY);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_COPY));
                this.putValue("SmallIcon", this.icons.getIcon(27));
                break;
            }
            case 1: {
                this.putValue("Name", NAME_PASTE);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_PASTE));
                this.putValue("SmallIcon", this.icons.getIcon(28));
                break;
            }
            case 2: {
                this.putValue("Name", NAME_RESET);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_RESET));
                this.putValue("SmallIcon", this.icons.getIcon(44));
                break;
            }
            case 3: {
                this.putValue("Name", NAME_SET_MIN_MAX);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_MIN_MAX));
                this.putValue("SmallIcon", this.icons.getIcon(45));
                break;
            }
            case 4: {
                this.putValue("Name", NAME_SET_OWNER);
                this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION_SET_OWNER));
                this.putValue("SmallIcon", this.icons.getIcon(46));
                break;
            }
            default: {
                throw new IllegalArgumentException("Index not supported.");
            }
        }
    }

    @Override
    protected void onStateChange() {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }

    @Override
    protected void onDisplayChange(ImageDisplay node) {
        if (!DataBrowserAgent.canCreate()) {
            this.setEnabled(false);
            return;
        }
        Browser browser = this.model.getBrowser();
        if (node == null || browser == null) {
            this.setEnabled(false);
            return;
        }
        Object ho = node.getHierarchyObject();
        Collection<DataObject> selected = browser.getSelectedDataObjects();
        int count = 0;
        switch (this.index) {
            case 0: {
                if (selected.size() > 1) {
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof WellSampleData || ho instanceof ImageData) {
                    this.setEnabled(this.model.canAnnotate(ho));
                    break;
                }
                this.setEnabled(false);
                break;
            }
            case 1: {
                if (!this.model.hasRndSettings()) {
                    this.setEnabled(false);
                    return;
                }
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData || ho instanceof PlateAcquisitionData || ho instanceof WellSampleData)) {
                    this.setEnabled(false);
                    break;
                }
                if (ho instanceof PlateData || ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateAcquisitionData || ho instanceof WellSampleData) {
                    Iterator<DataObject> i = selected.iterator();
                    while (i.hasNext()) {
                        DataObject obj;
                        DataObject data = obj = i.next();
                        if (!this.model.canAnnotate(obj) || !this.model.areSettingsCompatible(data.getGroupId())) continue;
                        ++count;
                    }
                    this.setEnabled(count == selected.size());
                    break;
                }
                this.setEnabled(true);
                break;
            }
            case 2: 
            case 3: {
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData || ho instanceof PlateAcquisitionData || ho instanceof WellSampleData)) {
                    this.setEnabled(false);
                    break;
                }
                for (DataObject obj : selected) {
                    if (!this.model.canAnnotate(obj)) continue;
                    ++count;
                }
                this.setEnabled(count == selected.size());
                break;
            }
            case 4: {
                if (!(ho instanceof ImageData || ho instanceof DatasetData || ho instanceof PlateData || ho instanceof PlateAcquisitionData || ho instanceof WellSampleData)) {
                    this.setEnabled(false);
                    break;
                }
                for (DataObject obj : selected) {
                    if (!this.model.canAnnotate(obj)) continue;
                    ++count;
                }
                this.setEnabled(count == selected.size());
            }
        }
    }

    public ManageRndSettingsAction(DataBrowser model, int index) {
        super(model);
        this.setEnabled(false);
        this.icons = IconManager.getInstance();
        this.checkIndex(index);
        this.index = index;
        model.addPropertyChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        switch (this.index) {
            case 0: {
                this.model.copyRndSettings();
                break;
            }
            case 1: {
                this.model.pasteRndSettings();
                break;
            }
            case 2: {
                this.model.resetRndSettings();
                break;
            }
            case 3: {
                this.model.setOriginalSettings();
                break;
            }
            case 4: {
                this.model.setOwnerSettings();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Browser browser;
        String name = evt.getPropertyName();
        if (("copyItems".equals(name) || "rndSettingToCopy".equals(name) || "selectedDataBrowserNodeDisplay".equals(name) || "selectedDataBrowserNodesDisplay".equals(name) || "selectionUpdated".equals(name)) && (browser = this.model.getBrowser()) != null) {
            this.onDisplayChange(browser.getLastSelectedDisplay());
        }
    }
}

