/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter;

import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import ome.model.units.Power;
import ome.model.units.Unit;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.xml.model.Laser;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.LaserMedium;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.Pulse;
import ome.xml.model.primitives.PercentFraction;
import ome.xml.model.primitives.PositiveInteger;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.DataConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.submodules.converter.OMEValueConverter;
import org.openmicroscopy.shoola.agents.fsimporter.mde.configuration.TagNames;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;
import org.openmicroscopy.shoola.util.ui.IconManager;

public class LaserConverter
extends DataConverter {
    @Override
    public JComponent getLabel(String name, int index, List<ActionListener> listeners) {
        JPanel labelPane = new JPanel();
        labelPane.setLayout(new BoxLayout(labelPane, 0));
        labelPane.setBorder(new EmptyBorder(5, 2, 2, 2));
        labelPane.setOpaque(false);
        JLabel label = new JLabel(name);
        label.setBorder(new EmptyBorder(0, 0, 0, 10));
        labelPane.add(label);
        IconManager icons = IconManager.getInstance();
        JButton applyBtn = new JButton(icons.getIcon(73));
        applyBtn.setToolTipText("Apply table selection");
        applyBtn.setAlignmentX(1.0f);
        labelPane.add(applyBtn);
        return labelPane;
    }

    public LinkedHashMap<String, TagData> convertData(Laser l, LightSourceSettings settings) {
        this.tagMap = new LinkedHashMap();
        if (l != null) {
            try {
                this.tagMap.put("ID", this.convertID(l.getID(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("ID", this.convertID(null, true));
            }
            try {
                this.tagMap.put("Manufacturer", this.convertManufact(l.getManufacturer(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            }
            try {
                this.tagMap.put("Model", this.convertModel(l.getModel(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Model", this.convertModel(null, true));
            }
            try {
                this.tagMap.put("Power", this.convertPower(l.getPower(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Power", this.convertPower(null, true));
            }
            try {
                this.tagMap.put("L_Type", this.convertType((Enumeration)l.getType(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("L_Type", this.convertType(null, true));
            }
            try {
                this.tagMap.put("Laser Medium", this.convertMedium(l.getLaserMedium(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Laser Medium", this.convertMedium(null, true));
            }
            try {
                this.tagMap.put("Frequency Multiplication", this.convertFreqMultiplication(l.getFrequencyMultiplication(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Frequency Multiplication", this.convertFreqMultiplication(null, true));
            }
            try {
                this.tagMap.put("Tunable", this.convertTunable(l.getTuneable(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Tunable", this.convertTunable(null, true));
            }
            try {
                this.tagMap.put("Pulse", this.convertPulse(l.getPulse(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Pulse", this.convertPulse(null, true));
            }
            try {
                this.tagMap.put("Pockel Cell", this.convertPocketCell(l.getPockelCell(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Pockel Cell", this.convertPocketCell(null, true));
            }
            try {
                this.tagMap.put("Repititation Rate", this.convertRepititationRate(l.getRepetitionRate(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Repititation Rate", this.convertRepititationRate(null, true));
            }
            try {
                this.tagMap.put("Pump", this.convertPump(l.getLinkedPump().getID(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Pump", this.convertPump(null, true));
            }
            try {
                this.tagMap.put("Wavelength", this.convertWavelength(l.getWavelength(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("Wavelength", this.convertWavelength(null, true));
            }
        } else {
            this.tagMap.put("ID", this.convertID(null, true));
            this.tagMap.put("Manufacturer", this.convertManufact(null, true));
            this.tagMap.put("Model", this.convertModel(null, true));
            this.tagMap.put("Power", this.convertPower(null, true));
            this.tagMap.put("L_Type", this.convertType(null, true));
            this.tagMap.put("Laser Medium", this.convertMedium(null, true));
            this.tagMap.put("Frequency Multiplication", this.convertFreqMultiplication(null, true));
            this.tagMap.put("Tunable", this.convertTunable(null, true));
            this.tagMap.put("Pulse", this.convertPulse(null, true));
            this.tagMap.put("Pockel Cell", this.convertPocketCell(null, true));
            this.tagMap.put("Repititation Rate", this.convertRepititationRate(null, true));
            this.tagMap.put("Pump", this.convertPump(null, true));
            this.tagMap.put("Wavelength", this.convertWavelength(null, true));
        }
        if (settings != null) {
            try {
                this.tagMap.put("User::Wavelength", this.convertWavelengthSett(settings.getWavelength(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Wavelength", this.convertWavelengthSett(null, true));
            }
            try {
                this.tagMap.put("User::Attenuation", this.convertAttenuation(settings.getAttenuation(), true));
            }
            catch (NullPointerException e) {
                this.tagMap.put("User::Attenuation", this.convertAttenuation(null, true));
            }
        } else {
            this.tagMap.put("User::Wavelength", this.convertWavelengthSett(null, true));
            this.tagMap.put("User::Attenuation", this.convertAttenuation(null, true));
        }
        return this.tagMap;
    }

    public TagData convertID(String value, boolean prop) {
        return new TagData("OME:Laser", "ID", value, prop, "TextField");
    }

    public TagData convertManufact(String value, boolean prop) {
        return new TagData("OME:Laser", "Manufacturer", value, prop, "TextField");
    }

    public TagData convertType(Enumeration value, boolean prop) {
        String val = value != null ? ((LaserType)value).getValue() : "";
        return new TagData("OME:Laser", "L_Type", val, prop, "ComboBox", OMEValueConverter.getNames(LaserType.class));
    }

    public TagData convertPower(ome.units.quantity.Power value, boolean prop) {
        Power val = null;
        if (value != null) {
            val = new Power(value);
        }
        TagData t = new TagData("OME:Laser", "Power", (Unit)val, Power.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertModel(String value, boolean prop) {
        return new TagData("OME:Laser", "Model", value, prop, "TextField");
    }

    public TagData convertMedium(LaserMedium value, boolean prop) {
        String val = value != null ? value.getValue() : "";
        return new TagData("OME:Laser", "Laser Medium", val, prop, "ComboBox", OMEValueConverter.getNames(LaserMedium.class));
    }

    public TagData convertFreqMultiplication(PositiveInteger value, boolean prop) {
        String val = value != null ? String.valueOf(value.getNumberValue()) : "";
        return new TagData("OME:Laser", "Frequency Multiplication", val, prop, "TextField");
    }

    public TagData convertTunable(Boolean value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Laser", "Tunable", val, prop, "ComboBox", TagNames.BOOLEAN_COMBO);
    }

    public TagData convertPulse(Pulse value, boolean prop) {
        String val = value != null ? value.getValue() : "";
        return new TagData("OME:Laser", "Pulse", val, prop, "ComboBox", OMEValueConverter.getNames(Pulse.class));
    }

    public TagData convertPocketCell(Boolean value, boolean prop) {
        String val = value != null ? String.valueOf(value) : "";
        return new TagData("OME:Laser", "Pockel Cell", val, prop, "ComboBox", TagNames.BOOLEAN_COMBO);
    }

    public TagData convertRepititationRate(Frequency value, boolean prop) {
        ome.model.units.Frequency val = null;
        if (value != null) {
            val = new ome.model.units.Frequency(value);
        }
        TagData t = new TagData("OME:Laser", "Repititation Rate", (Unit)val, ome.model.units.Frequency.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertPump(String value, boolean prop) {
        return new TagData("OME:Laser", "Pump", value, prop, "TextField");
    }

    public TagData convertWavelength(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        TagData t = new TagData("OME:Laser", "Wavelength", (Unit)val, ome.model.units.Length.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerDouble(t, "Invalid input. Use float!"));
        return t;
    }

    public TagData convertWavelengthSett(Length value, boolean prop) {
        ome.model.units.Length val = null;
        if (value != null) {
            val = new ome.model.units.Length(value);
        }
        TagData t = new TagData("OME:Laser", "User::Wavelength", (Unit)val, ome.model.units.Length.class, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPosFloat(t, "Invalid input. Use float>0!"));
        return t;
    }

    public TagData convertAttenuation(PercentFraction value, boolean prop) {
        String val = value != null ? String.valueOf(value.getNumberValue()) : "";
        TagData t = new TagData("OME:Laser", "User::Attenuation", val, prop, "TextField");
        t.setDocumentListener(this.createDocumentListenerPercentFraction(t, "Invalid input. Use percent fraction as dezimal between 0.0 and 1.0!"));
        return t;
    }
}

