/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.configuration;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.fsimporter.mde.components.ModuleContent;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.TagData;

public class Editor_TagDataProp
extends JPanel {
    private JPanel rowData;
    private ModuleContent content;
    private ModuleContent origContent;
    private int numberOfLabels = 3;

    public Editor_TagDataProp(ModuleContent content) {
        if (content != null) {
            this.content = new ModuleContent(content);
            this.origContent = content;
            this.rowData = new JPanel(new GridBagLayout());
            if (content != null) {
                this.addDataRow(content.getList());
            }
            this.add(this.rowData);
        }
    }

    public void saveContent() {
        if (this.rowData == null) {
            return;
        }
        for (int i = this.numberOfLabels; i < this.rowData.getComponentCount(); i += 3) {
            String name = ((JLabel)this.rowData.getComponent(i)).getText();
            Object unit = null;
            if (this.rowData.getComponent(i + 1) instanceof JComboBox) {
                unit = ((JComboBox)this.rowData.getComponent(i + 1)).getSelectedItem();
            }
            boolean visible = ((JCheckBox)this.rowData.getComponent(i + 2)).isSelected();
            TagData t = this.content.getTag(name);
            if (unit != null) {
                t.setTagUnit(String.valueOf(unit));
            }
            t.setVisible(visible);
            this.content.set(((JLabel)this.rowData.getComponent(i)).getText(), t);
        }
    }

    public void resetContent() {
        this.rowData.removeAll();
        this.content = this.origContent;
        this.addDataRow(this.content.getList());
    }

    private void addDataRow(LinkedHashMap<String, TagData> list) {
        JLabel lName = new JLabel("TagName");
        lName.setFont(lName.getFont().deriveFont(1));
        JLabel lUnit = new JLabel("Unit");
        lUnit.setFont(lUnit.getFont().deriveFont(1));
        JLabel lVisible = new JLabel("Visible");
        lVisible.setFont(lVisible.getFont().deriveFont(1));
        JLabel lRequired = new JLabel("Required");
        lRequired.setFont(lRequired.getFont().deriveFont(1));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        if (list != null) {
            c.insets = new Insets(0, 1, 1, 0);
            c.gridwidth = 1;
            c.fill = 2;
            this.addGB(lName, 0, 0, c);
            this.addGB(lUnit, 1, 0, c);
            this.addGB(lVisible, 2, 0, c);
            this.addGB(lRequired, 3, 0, c);
            int y = 1;
            for (Map.Entry<String, TagData> entry : list.entrySet()) {
                TagData t = entry.getValue();
                c.weightx = 1.0;
                this.addGB(new JLabel(t.getTagName()), 0, y, c);
                if (!t.getTagUnitString().equals("")) {
                    JComboBox unitCB = t.getUnitCombo();
                    this.addGB(unitCB, 1, y, c);
                } else {
                    this.addGB(new JLabel(""), 1, y, c);
                }
                c.weightx = 0.5;
                JCheckBox cb = new JCheckBox();
                cb.setSelected(t.isVisible());
                this.addGB(cb, 2, y, c);
                c.weightx = 0.5;
                JCheckBox cb2 = new JCheckBox();
                cb2.setSelected(t.isRequired());
                this.addGB(cb2, 2, y, c);
                ++y;
            }
        }
    }

    private void addGB(Component comp, int x, int y, GridBagConstraints c) {
        c.gridx = x;
        c.gridy = y;
        this.rowData.add(comp, c);
    }

    public ModuleContent getContent() {
        if (this.rowData == null) {
            return this.origContent;
        }
        return this.content;
    }
}

