/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.mde.util.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import omero.log.LogMessage;
import org.openmicroscopy.shoola.agents.fsimporter.mde.util.OntologyElement;

public abstract class OntologyParser {
    String REST_URL;
    String acronym;
    static final ObjectMapper mapper = new ObjectMapper();

    public OntologyParser(String ontology_restapi_url) {
        this(ontology_restapi_url, "");
    }

    public OntologyParser(String ontology_restapi_url, String acronym) {
        this.acronym = acronym;
        this.REST_URL = ontology_restapi_url;
    }

    public List<OntologyElement> getSubLabels(String ontology_acronym, String termID_href) throws Exception {
        List<OntologyElement> labels = null;
        if (ontology_acronym == null || ontology_acronym.isEmpty() || termID_href == null || termID_href.isEmpty()) {
            return null;
        }
        try {
            JsonNode ontology_node = this.getNode(this.formatURL(ontology_acronym, termID_href));
            labels = this.getSubClassLabels(ontology_node);
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print(String.format("Exception while getting sub labels for %s", termID_href));
            msg.print((Throwable)e);
        }
        return labels;
    }

    JsonNode getNode(String url) throws Exception {
        String ontology_string = this.get_inputStreamAsStringFromURL(url);
        JsonNode ontology = OntologyParser.stringToJsonNode(ontology_string);
        return ontology;
    }

    static JsonNode stringToJsonNode(String json) throws Exception {
        JsonNode root = mapper.readTree(json);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String get_inputStreamAsStringFromURL(String urlToGet) {
        BufferedReader rd = null;
        Object result = "";
        try {
            String line;
            URL url = new URL(urlToGet);
            HttpURLConnection conn = this.initURLConnection(url);
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = (String)result + line;
            }
        }
        catch (Exception e) {
            LogMessage msg = new LogMessage();
            msg.print(String.format("Exception while creating url for %s", urlToGet));
            msg.print((Throwable)e);
        }
        finally {
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (Exception exception) {}
        }
        return result;
    }

    protected abstract String formatURL(String var1, String var2);

    protected abstract List<OntologyElement> getSubClassLabels(JsonNode var1) throws Exception;

    protected abstract List<String> getSubClassLabelsWithParents(JsonNode var1, String var2) throws Exception;

    protected abstract HttpURLConnection initURLConnection(URL var1) throws Exception;
}

