/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.util;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.apache.commons.io.FilenameUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ChecksumTableRenderer
extends DefaultTableCellRenderer {
    static final int MAX_CHARACTERS = 10;
    private final Icon failure;
    private final Icon success;
    private final Color foreground;

    ChecksumTableRenderer(Icon failure, Icon success) {
        this.failure = failure;
        this.success = success;
        this.foreground = this.getForeground();
        this.setOpaque(true);
        this.setHorizontalAlignment(2);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setIcon(null);
        this.setText("");
        this.setToolTipText("");
        this.setForeground(this.foreground);
        if (value instanceof Boolean) {
            Boolean v = (Boolean)value;
            if (v.booleanValue()) {
                this.setIcon(this.success);
            } else {
                this.setIcon(this.failure);
            }
        } else if (value instanceof String) {
            Boolean b = (Boolean)table.getValueAt(row, 3);
            if (!b.booleanValue()) {
                this.setForeground(UIUtilities.REQUIRED_FIELDS_COLOR);
            }
            String v = (String)value;
            this.setToolTipText(v);
            if (column > 0) {
                if (v.length() > 10) {
                    this.setText(v.substring(0, 10));
                } else {
                    this.setText(v);
                }
            } else {
                this.setText(FilenameUtils.getName((String)v));
            }
        }
        return this;
    }
}

