/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.actions;

import org.openmicroscopy.shoola.agents.imviewer.actions.ZoomAction;
import org.openmicroscopy.shoola.agents.imviewer.view.ImViewer;

public class ZoomCmd {
    public static final int ZOOM_IN = 0;
    public static final int ZOOM_OUT = 1;
    static final double INCREMENT = 0.25;
    private static final double MOUSE_INCREMENT = 0.1;
    private int index;
    private ImViewer model;

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not valid.");
    }

    public static int getZoomIndex(double factor) {
        double f = (double)Math.round(factor * 100.0) / 100.0;
        if (f < 0.25) {
            f = 0.25;
        }
        if (f > 3.0) {
            f = 3.0;
        }
        return ZoomAction.getIndex(f);
    }

    public ZoomCmd(ImViewer model, int index) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.checkIndex(index);
        this.model = model;
        this.index = index;
    }

    public void execute() {
        if (this.model.isBigImage()) {
            int level = this.model.getSelectedResolutionLevel();
            switch (this.index) {
                case 0: {
                    ++level;
                    break;
                }
                case 1: {
                    --level;
                }
            }
            if (level >= this.model.getResolutionLevels() || level < 0) {
                return;
            }
            double f = ZoomAction.getZoomFactor(level);
            this.model.setZoomFactor(f, level);
            return;
        }
        double f = this.model.getZoomFactor();
        if (f < 0.0) {
            return;
        }
        double zoomFactor = 1.0;
        switch (this.index) {
            case 0: {
                if (f >= 3.0) {
                    zoomFactor = 3.0;
                    break;
                }
                zoomFactor = f + 0.1;
                break;
            }
            case 1: {
                zoomFactor = f <= 0.25 ? 0.25 : f - 0.1;
            }
        }
        f = (double)Math.round(zoomFactor * 100.0) / 100.0;
        if (f < 0.25) {
            f = 0.25;
        }
        if (f > 3.0) {
            f = 3.0;
        }
        this.model.setZoomFactor(f, ZoomCmd.getZoomIndex(zoomFactor));
    }
}

