/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.browser;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Map;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.imviewer.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.imviewer.browser.ImageCanvas;
import org.openmicroscopy.shoola.agents.imviewer.util.ImagePaintingFactory;
import org.openmicroscopy.shoola.env.rnd.data.Region;
import org.openmicroscopy.shoola.env.rnd.data.Tile;

class BrowserBICanvas
extends ImageCanvas {
    BrowserBICanvas(BrowserModel model, BrowserUI view) {
        super(model, view);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2D = (Graphics2D)g;
        ImagePaintingFactory.setGraphicRenderingSettings(g2D, this.model.isInterpolation());
        if (this.model.isBigImage()) {
            g2D.setColor(BACKGROUND);
            g2D.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            Map<Integer, Tile> tiles = this.model.getTiles();
            int rows = this.model.getRows();
            int columns = this.model.getColumns();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < columns; ++j) {
                    int index = i * columns + j;
                    Tile tile = tiles.get(index);
                    Region region = tile.getRegion();
                    Object img = tile.getImage();
                    if (img != null) {
                        g2D.drawImage((Image)((BufferedImage)img), region.getX(), region.getY(), null);
                        continue;
                    }
                    g2D.drawRect(region.getX(), region.getY(), region.getWidth(), region.getHeight());
                }
            }
            this.paintScaleBar(g2D, this.model.getTiledImageSizeX(), this.model.getTiledImageSizeY(), this.view.getViewport());
        } else {
            BufferedImage img = this.model.getDisplayedImage();
            if (img == null) {
                return;
            }
            g2D.drawImage((Image)img, 0, 0, null);
            this.paintScaleBar(g2D, img.getWidth(), img.getHeight(), this.view.getViewport());
        }
        g2D.dispose();
    }
}

