/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.sql.Timestamp;
import org.openmicroscopy.shoola.agents.imviewer.util.HistoryItemCanvas;
import org.openmicroscopy.shoola.env.data.model.ProjectionParam;
import org.openmicroscopy.shoola.env.rnd.RndProxyDef;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.tpane.TinyPane;

public class HistoryItem
extends TinyPane {
    private RndProxyDef settings;
    private BufferedImage thumbnail;
    private Timestamp time;
    private HistoryItemCanvas canvas;
    private int index;
    private ProjectionParam ref;
    private int defaultT;
    private Color originalColor;

    public HistoryItem(RndProxyDef settings, BufferedImage thumbnail, String title) {
        if (settings == null) {
            throw new IllegalArgumentException("No rnd settings specified.");
        }
        if (thumbnail == null) {
            throw new IllegalArgumentException("No rendered image specified.");
        }
        this.settings = settings;
        this.thumbnail = thumbnail;
        this.time = UIUtilities.getDefaultTimestamp();
        if (title == null || title.trim().length() == 0) {
            title = UIUtilities.formatShortDateTime(this.time);
        }
        this.setToolTipText(UIUtilities.formatShortDateTime(this.time));
        this.setTitle(title);
        this.allowClose(true);
        this.setTitleBarType(5);
        this.setListenToBorder(false);
        this.canvas = new HistoryItemCanvas(this);
        this.getInternalDesktop().add(this.canvas);
        int w = thumbnail.getWidth();
        int h = thumbnail.getHeight();
        this.canvas.setBounds(0, 0, w, h);
        this.getInternalDesktop().setSize(w, h);
        this.getInternalDesktop().setPreferredSize(new Dimension(w, h));
        this.ref = null;
    }

    public void setProjectionRef(ProjectionParam ref) {
        this.ref = ref;
    }

    public void setDefaultT(int defaultT) {
        this.defaultT = defaultT;
    }

    public int getDefaultT() {
        return this.defaultT;
    }

    public ProjectionParam getProjectionRef() {
        return this.ref;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public RndProxyDef getRndSettings() {
        return this.settings;
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    public void setOriginalColor(Color originalColor) {
        this.originalColor = originalColor;
    }

    public Color getOriginalColor() {
        return this.originalColor;
    }

    public void addMouseListenerToComponents(MouseListener listener) {
        this.getTitleBar().addMouseListener(listener);
        this.addMouseListener(listener);
        this.canvas.addMouseListener(listener);
    }
}

