/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.imviewer.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.imviewer.IconManager;
import org.openmicroscopy.shoola.agents.imviewer.view.ViewerPreferences;
import org.openmicroscopy.shoola.util.ui.TitlePanel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class PreferencesDialog
extends JDialog
implements ActionListener {
    public static final String VIEWER_PREF_PROPERTY = "viewerPref";
    private static final String TITLE = "Viewer Preferences...";
    private static final String TEXT = "Sets the Viewer preferences";
    private static final Dimension H_BOX = new Dimension(10, 0);
    private static final int CANCEL = 0;
    private static final int APPLY = 1;
    private static final int CLEAR = 2;
    private JButton finishButton;
    private JButton cancelButton;
    private JButton clearButton;
    private JCheckBox windowBounds;
    private JCheckBox rnd;
    private JCheckBox history;
    private JCheckBox zoom;
    private JCheckBox scaleBar;
    private JCheckBox bgColor;

    private void initComponents(ViewerPreferences preferences) {
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.setActionCommand("0");
        this.finishButton = new JButton("Apply");
        this.finishButton.addActionListener(this);
        this.finishButton.setActionCommand("1");
        this.clearButton = new JButton("Clear");
        this.clearButton.addActionListener(this);
        this.clearButton.setActionCommand("2");
        this.getRootPane().setDefaultButton(this.finishButton);
        this.windowBounds = new JCheckBox("Viewer Bounds");
        this.rnd = new JCheckBox("Renderer");
        this.history = new JCheckBox("History");
        this.zoom = new JCheckBox("Zoom factor");
        this.scaleBar = new JCheckBox("Scale bar settings");
        this.bgColor = new JCheckBox("Background color");
        if (preferences != null) {
            this.rnd.setSelected(preferences.isFieldSelected("Renderer"));
            this.history.setSelected(preferences.isFieldSelected("History"));
            this.zoom.setSelected(preferences.isFieldSelected("Zoom factor"));
            this.scaleBar.setSelected(preferences.isFieldSelected("Scale bar settings"));
            this.bgColor.setSelected(preferences.isFieldSelected("Background color"));
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void save() {
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        boolean b = false;
        if (this.windowBounds.isSelected()) {
            b = true;
        }
        m.put("Viewer Bounds", this.windowBounds.isSelected());
        if (this.rnd.isSelected()) {
            b = true;
        }
        m.put("Renderer", this.rnd.isSelected());
        if (this.history.isSelected()) {
            b = true;
        }
        m.put("History", this.history.isSelected());
        if (this.zoom.isSelected()) {
            b = true;
        }
        m.put("Zoom factor", this.zoom.isSelected());
        if (this.scaleBar.isSelected()) {
            b = true;
        }
        m.put("Scale bar settings", this.scaleBar.isSelected());
        if (this.bgColor.isSelected()) {
            b = true;
        }
        m.put("Background color", this.bgColor.isSelected());
        if (!b) {
            m = null;
        }
        this.firePropertyChange(VIEWER_PREF_PROPERTY, null, m);
        this.close();
    }

    private void clear() {
        this.firePropertyChange(VIEWER_PREF_PROPERTY, "", null);
        this.close();
    }

    private void setDialogProperties() {
        this.setModal(true);
        this.setResizable(true);
        this.setTitle(TITLE);
    }

    private JPanel buildToolBar() {
        JPanel toolBar = new JPanel();
        toolBar.add(this.cancelButton);
        toolBar.add(Box.createRigidArea(H_BOX));
        toolBar.add(this.clearButton);
        toolBar.add(Box.createRigidArea(H_BOX));
        toolBar.add(this.finishButton);
        return toolBar;
    }

    private JPanel buildBody() {
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 1));
        body.add(this.rnd);
        body.add(this.history);
        body.add(this.zoom);
        body.add(this.scaleBar);
        body.add(this.bgColor);
        return body;
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        IconManager icons = IconManager.getInstance();
        TitlePanel tp = new TitlePanel(TITLE, TEXT, icons.getIcon(52));
        c.add((Component)((Object)tp), "North");
        c.add((Component)this.buildBody(), "Center");
        c.add((Component)UIUtilities.buildComponentPanelRight(this.buildToolBar()), "South");
    }

    public PreferencesDialog(JFrame owner, ViewerPreferences pref) {
        super(owner);
        this.setDialogProperties();
        this.initComponents(pref);
        this.buildGUI();
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                this.save();
                break;
            }
            case 2: {
                this.clear();
            }
        }
    }
}

