/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.metadata.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import omero.gateway.model.AnnotationData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.MapAnnotationData;
import omero.model.NamedValue;
import org.openmicroscopy.shoola.agents.metadata.IconManager;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.metadata.editor.AnnotationTaskPaneUI;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorControl;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorModel;
import org.openmicroscopy.shoola.agents.metadata.editor.EditorUI;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTable;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTableModel;
import org.openmicroscopy.shoola.agents.metadata.editor.maptable.MapTableSelectionModel;
import org.openmicroscopy.shoola.agents.metadata.view.MetadataViewerFactory;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.ToolTipGenerator;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class MapTaskPaneUI
extends AnnotationTaskPaneUI
implements ListSelectionListener {
    private static final int MAX_TABLES_COMPONENT_WIDTH = 200;
    private static final int MAX_TABLES_COMPONENT_HEIGHT = 300;
    private JPanel toolbar;
    private JButton addButton;
    private JButton copyButton;
    private JButton pasteButton;
    private JButton deleteButton;
    private List<MapTable> mapTables = new ArrayList<MapTable>();
    private boolean listenerActive = true;
    private GridBagConstraints c;
    private static List<NamedValue> copiedValues = MetadataViewerFactory.getCopiedMapAnnotationsEntries();
    private JPanel headerPanel = null;
    private JPanel tablePanel = null;
    private JScrollPane sp;

    MapTaskPaneUI(EditorModel model, EditorUI view, EditorControl controller) {
        super(model, view, controller);
        this.buildUI();
    }

    @Override
    List<AnnotationData> getAnnotationsToSave() {
        List<MapAnnotationData> tmp = this.getMapAnnotations(true, true);
        ArrayList<AnnotationData> result = new ArrayList<AnnotationData>();
        result.addAll(tmp);
        return result;
    }

    @Override
    List<Object> getAnnotationsToRemove() {
        List<MapAnnotationData> tmp = this.getEmptyMapAnnotations();
        ArrayList<Object> result = new ArrayList<Object>();
        result.addAll(tmp);
        return result;
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.toolbar = this.createToolBar();
        this.toolbar.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.add((Component)this.toolbar, "North");
        this.c = new GridBagConstraints();
        this.c.anchor = 18;
        this.c.insets = new Insets(0, 2, 4, 2);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.weightx = 1.0;
        this.c.weighty = 0.0;
        this.c.fill = 2;
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new GridBagLayout());
        this.tablePanel.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.sp = new JScrollPane(this.tablePanel);
        this.sp.setBorder(BorderFactory.createEmptyBorder());
        this.tablePanel.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (MapTaskPaneUI.this.view != null) {
                    MapTaskPaneUI.this.adjustScrollPane();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add((Component)this.sp, "Center");
        this.sp.setPreferredSize(null);
        this.headerPanel = this.createHeaderPanel();
        this.tablePanel.add((Component)this.headerPanel, this.c);
        ++this.c.gridy;
    }

    private void adjustScrollPane() {
        this.tablePanel.setPreferredSize(null);
        Dimension d = this.tablePanel.getPreferredSize();
        if (d.width > 200) {
            d.width = 200;
        }
        if (d.height > 300) {
            d.height = 300;
        }
        d.width += 5;
        d.height += 5;
        this.sp.setPreferredSize(d);
        this.view.revalidate();
    }

    private JPanel createToolBar() {
        JPanel bar = new JPanel();
        bar.setLayout(new BoxLayout(bar, 0));
        bar.add(Box.createHorizontalGlue());
        IconManager icons = IconManager.getInstance();
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!((JButton)e.getSource()).isEnabled()) {
                    return;
                }
                if (e.getSource() == MapTaskPaneUI.this.addButton) {
                    MapTaskPaneUI.this.insertRow();
                }
                if (e.getSource() == MapTaskPaneUI.this.copyButton) {
                    MapTaskPaneUI.this.copySelection();
                }
                if (e.getSource() == MapTaskPaneUI.this.pasteButton) {
                    MapTaskPaneUI.this.pasteSelection();
                }
                if (e.getSource() == MapTaskPaneUI.this.deleteButton) {
                    MapTaskPaneUI.this.deleteSelection();
                }
            }
        };
        this.addButton = new JButton(icons.getIcon(127));
        UIUtilities.unifiedButtonLookAndFeel(this.addButton);
        this.addButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.addButton.setToolTipText("Insert row");
        this.addButton.addMouseListener(ml);
        this.addButton.setEnabled(false);
        this.addButton.setFocusable(false);
        bar.add(this.addButton);
        this.copyButton = new JButton(icons.getIcon(125));
        UIUtilities.unifiedButtonLookAndFeel(this.copyButton);
        this.copyButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.copyButton.setToolTipText("Copy rows");
        this.copyButton.addMouseListener(ml);
        this.copyButton.setEnabled(false);
        this.copyButton.setFocusable(false);
        bar.add(this.copyButton);
        this.pasteButton = new JButton(icons.getIcon(126));
        UIUtilities.unifiedButtonLookAndFeel(this.pasteButton);
        this.pasteButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.pasteButton.setToolTipText("Paste rows");
        this.pasteButton.addMouseListener(ml);
        this.pasteButton.setEnabled(false);
        this.pasteButton.setFocusable(false);
        bar.add(this.pasteButton);
        this.deleteButton = new JButton(icons.getIcon(82));
        UIUtilities.unifiedButtonLookAndFeel(this.deleteButton);
        this.deleteButton.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.deleteButton.setToolTipText("Delete rows");
        this.deleteButton.addMouseListener(ml);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setFocusable(false);
        bar.add(this.deleteButton);
        return bar;
    }

    private JPanel createHeaderPanel() {
        JPanel p = new JPanel(new GridLayout(1, 2));
        p.setBackground(UIUtilities.BACKGROUND_COLOR);
        JLabel l = this.constructHeaderLabel("Key");
        l.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, Color.LIGHT_GRAY));
        p.add(l);
        p.add(this.constructHeaderLabel("Value"));
        return p;
    }

    private JLabel constructHeaderLabel(String text) {
        JLabel l = new JLabel(" " + text);
        Font f = l.getFont().deriveFont(2);
        l.setForeground(UIUtilities.DEFAULT_FONT_COLOR);
        l.setFont(f);
        return l;
    }

    @Override
    void clearDisplay() {
        this.mapTables.clear();
        this.tablePanel.removeAll();
        this.c.gridy = 0;
        this.tablePanel.add((Component)this.headerPanel, this.c);
        ++this.c.gridy;
    }

    @Override
    public void filter(AnnotationTaskPaneUI.Filter filter) {
        for (MapTable table : this.mapTables) {
            table.getParent().setVisible(false);
            if (this.isUsers(table.getData()) && (filter == AnnotationTaskPaneUI.Filter.ADDED_BY_ME || filter == AnnotationTaskPaneUI.Filter.SHOW_ALL)) {
                table.getParent().setVisible(true);
            }
            if (this.isOtherUsers(table.getData()) && (filter == AnnotationTaskPaneUI.Filter.ADDED_BY_OTHERS || filter == AnnotationTaskPaneUI.Filter.SHOW_ALL)) {
                table.getParent().setVisible(true);
            }
            if (!this.isOther(table.getData()) || filter != AnnotationTaskPaneUI.Filter.SHOW_ALL) continue;
            table.getParent().setVisible(true);
        }
    }

    private String generateToolTip(MapAnnotationData ma) {
        Timestamp created;
        String desc;
        String ns;
        ToolTipGenerator tt = new ToolTipGenerator();
        ExperimenterData exp = null;
        if (ma.getId() > 0L) {
            exp = this.model.getOwner(ma);
            tt.addLine("ID", "" + ma.getId(), true);
        }
        if (!CommonsLangUtils.isEmpty(ns = ma.getNameSpace()) && !EditorUtil.isInternalNS(ns)) {
            tt.addLine("Namespace", ns, true);
        }
        if (!CommonsLangUtils.isEmpty(desc = ma.getDescription())) {
            tt.addLine("Description", desc, true);
        }
        if (exp != null) {
            tt.addLine("Owner", EditorUtil.formatExperimenter(exp), true);
        }
        if ((created = ma.getCreated()) != null) {
            tt.addLine("Date", UIUtilities.formatDefaultDate(created), true);
        }
        return tt.toString();
    }

    private void refreshButtonStates() {
        this.addButton.setEnabled(this.canInsert());
        this.copyButton.setEnabled(this.canCopy());
        this.pasteButton.setEnabled(this.canPaste());
        this.deleteButton.setEnabled(this.canDelete());
    }

    private MapTable findTable(MapAnnotationData data) {
        for (MapTable table : this.mapTables) {
            if (table.getData().getId() != data.getId()) continue;
            return table;
        }
        if (this.isUsers(data)) {
            for (MapTable table : this.mapTables) {
                if (table.getData().getId() >= 0L) continue;
                return table;
            }
        }
        return null;
    }

    private boolean isUsers(MapAnnotationData data) {
        return "openmicroscopy.org/omero/client/mapAnnotation".equals(data.getNameSpace()) && (data.getOwner() == null || MetadataViewerAgent.getUserDetails().getId() == data.getOwner().getId());
    }

    private boolean isOtherUsers(MapAnnotationData data) {
        return "openmicroscopy.org/omero/client/mapAnnotation".equals(data.getNameSpace()) && !this.isUsers(data);
    }

    private boolean isOther(MapAnnotationData data) {
        return !"openmicroscopy.org/omero/client/mapAnnotation".equals(data.getNameSpace());
    }

    private MapTable createMapTable(MapAnnotationData m) {
        boolean editable;
        boolean bl = editable = this.isUsers(m) && this.model.canAnnotate() || this.model.canEdit(m) && "openmicroscopy.org/omero/client/mapAnnotation".equals(m.getNameSpace());
        if (!editable && (m.getContent() == null || ((List)m.getContent()).isEmpty())) {
            return null;
        }
        int permissions = editable ? MapTable.PERMISSION_DELETE | MapTable.PERMISSION_MOVE | MapTable.PERMISSION_EDIT : MapTable.PERMISSION_NONE;
        final MapTable t = new MapTable(permissions);
        t.getSelectionModel().addListSelectionListener(this);
        t.setData(m);
        t.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                MapTaskPaneUI.this.refreshButtonStates();
                MapTableModel m = (MapTableModel)t.getModel();
                if (m.isEmpty() && m.getMap().getId() >= 0L) {
                    MapTaskPaneUI.this.view.deleteAnnotation(m.getMap());
                    MapTaskPaneUI.this.view.saveData(true);
                }
                MapTaskPaneUI.this.adjustScrollPane();
            }
        });
        this.mapTables.add(t);
        return t;
    }

    public List<MapAnnotationData> getMapAnnotations(boolean onlyDirty, boolean excludeEmpty) {
        ArrayList<MapAnnotationData> result = new ArrayList<MapAnnotationData>();
        for (MapTable t : this.mapTables) {
            if (t.getCellEditor() != null) {
                t.getCellEditor().stopCellEditing();
            }
            if (onlyDirty && !((MapTableModel)t.getModel()).isDirty() || excludeEmpty && t.isEmpty()) continue;
            result.add(t.getData());
        }
        return result;
    }

    public List<MapAnnotationData> getEmptyMapAnnotations() {
        ArrayList<MapAnnotationData> result = new ArrayList<MapAnnotationData>();
        for (MapTable t : this.mapTables) {
            if (!t.isEmpty()) continue;
            result.add(t.getData());
        }
        return result;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.listenerActive) {
            this.listenerActive = false;
            MapTable src = ((MapTableSelectionModel)e.getSource()).getTable();
            for (MapTable t : this.mapTables) {
                if (t == src) continue;
                t.getSelectionModel().clearSelection();
            }
            this.listenerActive = true;
            this.refreshButtonStates();
        }
    }

    public MapTable getSelectedTable() {
        for (MapTable t : this.mapTables) {
            if (t.getSelectedRow() == -1) continue;
            return t;
        }
        return null;
    }

    public MapTable getUserTable() {
        for (MapTable t : this.mapTables) {
            if (!this.isUsers(t.getData())) continue;
            return t;
        }
        return null;
    }

    public List<NamedValue> getSelection() {
        MapTable t = this.getSelectedTable();
        if (t != null) {
            return t.getSelection();
        }
        return Collections.emptyList();
    }

    private void insertRow() {
        MapTable t = this.getSelectedTable();
        if (t == null) {
            t = this.getUserTable();
        }
        if (t == null) {
            return;
        }
        MapTableModel m = (MapTableModel)t.getModel();
        int index = t.getSelectedRow() == -1 ? t.getRowCount() : t.getSelectedRow() + 1;
        m.addEntries(Arrays.asList(new NamedValue("", "")), index);
        t.requestFocus();
        t.getSelectionModel().setSelectionInterval(index, index);
        t.setColumnSelectionInterval(0, 0);
    }

    private void copySelection() {
        copiedValues.clear();
        copiedValues.addAll(this.getSelection());
        this.refreshButtonStates();
    }

    private List<NamedValue> deepCopy(List<NamedValue> original) {
        ArrayList<NamedValue> result = new ArrayList<NamedValue>();
        for (NamedValue orig : original) {
            NamedValue copy = new NamedValue(orig.name, orig.value);
            result.add(copy);
        }
        return result;
    }

    private void pasteSelection() {
        MapTable t = this.getSelectedTable();
        if (t == null) {
            t = this.getUserTable();
        }
        if (t == null) {
            return;
        }
        MapTableModel m = (MapTableModel)t.getModel();
        int index = t.getSelectedRow() + 1;
        m.addEntries(this.deepCopy(copiedValues), index);
        t.requestFocus();
        t.getSelectionModel().setSelectionInterval(index += copiedValues.size() - 1, index);
    }

    private void deleteSelection() {
        MapTable t = this.getSelectedTable();
        int index = t.getSelectedRow();
        t.deleteSelected();
        if (index >= t.getRowCount()) {
            index = t.getRowCount() - 1;
        }
        t.requestFocus();
        t.getSelectionModel().setSelectionInterval(index, index);
    }

    private boolean canInsert() {
        MapTable t = this.getSelectedTable();
        return (t == null || t == this.getUserTable()) && this.model.canAnnotate() || t != null && t.canEdit();
    }

    private boolean canDelete() {
        return !this.getSelection().isEmpty() && this.getSelectedTable().canDelete();
    }

    private boolean canCopy() {
        return !this.getSelection().isEmpty();
    }

    private boolean canPaste() {
        return !copiedValues.isEmpty() && (this.getSelectedTable() == null || this.getSelectedTable().canEdit());
    }

    @Override
    void refreshUI() {
        ArrayList<MapAnnotationData> list = new ArrayList<MapAnnotationData>();
        if (this.filter == AnnotationTaskPaneUI.Filter.SHOW_ALL || this.filter == AnnotationTaskPaneUI.Filter.ADDED_BY_ME) {
            list.addAll(this.model.getMapAnnotations(EditorModel.MapAnnotationType.USER));
            if (list.isEmpty()) {
                MapAnnotationData newMA = new MapAnnotationData();
                newMA.setNameSpace("openmicroscopy.org/omero/client/mapAnnotation");
                list.add(newMA);
            }
        }
        if (this.filter == AnnotationTaskPaneUI.Filter.SHOW_ALL || this.filter == AnnotationTaskPaneUI.Filter.ADDED_BY_OTHERS) {
            list.addAll(this.model.getMapAnnotations(EditorModel.MapAnnotationType.OTHER_USERS));
        }
        list.addAll(this.model.getMapAnnotations(EditorModel.MapAnnotationType.OTHER));
        for (MapAnnotationData ma : list) {
            MapTable t = this.findTable(ma);
            if (t != null) {
                t.setData(ma);
                continue;
            }
            String title = ma.getOwner() != null && !this.isUsers(ma) ? "Added by: " + EditorUtil.formatExperimenter(ma.getOwner()) : "";
            JPanel p = new JPanel();
            p.setBackground(UIUtilities.BACKGROUND_COLOR);
            UIUtilities.setBoldTitledBorder(title, p);
            p.setToolTipText(this.generateToolTip(ma));
            p.setLayout(new BorderLayout());
            t = this.createMapTable(ma);
            if (t == null) continue;
            p.add((Component)t, "Center");
            if (!CommonsLangUtils.isEmpty(ma.getNameSpace()) && !"openmicroscopy.org/omero/client/mapAnnotation".matches(ma.getNameSpace())) {
                JLabel ns = new JLabel(UIUtilities.formatPartialName(ma.getNameSpace()));
                ns.setFont(ns.getFont().deriveFont(1));
                p.add((Component)ns, "North");
            }
            this.tablePanel.add((Component)p, this.c);
            ++this.c.gridy;
        }
        this.refreshButtonStates();
        this.setVisible(!this.mapTables.isEmpty());
        this.adjustScrollPane();
    }

    @Override
    void onRelatedNodesSet() {
        this.clearDisplay();
        this.refreshButtonStates();
    }

    @Override
    int getUnfilteredAnnotationCount() {
        int count = 0;
        for (EditorModel.MapAnnotationType type : EditorModel.MapAnnotationType.values()) {
            for (MapAnnotationData map : this.model.getMapAnnotations(type)) {
                if (((Collection)map.getContent()).isEmpty()) continue;
                ++count;
            }
        }
        return count;
    }
}

