/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.actions;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.actions.TreeViewerAction;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class SwitchGroup
extends TreeViewerAction
implements MouseListener {
    public static final String NAME = "Display Group...";
    public static final String DESCRIPTION = "Select the groups to add to the tree.";
    private Point point;

    public SwitchGroup(TreeViewer model) {
        super(model);
        this.setEnabled(true);
        this.name = NAME;
        this.putValue("ShortDescription", UIUtilities.formatToolTipText(DESCRIPTION));
        IconManager im = IconManager.getInstance();
        this.putValue("SmallIcon", im.getIcon(152));
    }

    public void setPoint(Point point) {
        this.point = point;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.point != null) {
            SwingUtilities.convertPointToScreen(this.point, (Component)e.getSource());
        }
        this.model.displayUserGroups(this.point);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.point = me.getPoint();
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

