/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.cmd;

import omero.gateway.SecurityContext;
import omero.gateway.model.DataObject;
import omero.gateway.model.ImageData;
import org.openmicroscopy.shoola.agents.treeviewer.TreeViewerAgent;
import org.openmicroscopy.shoola.agents.treeviewer.browser.Browser;
import org.openmicroscopy.shoola.agents.treeviewer.cmd.ActionCmd;
import org.openmicroscopy.shoola.agents.treeviewer.view.TreeViewer;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.env.data.events.ViewInPluginEvent;

public class ViewInPluginCmd
implements ActionCmd {
    private TreeViewer model;
    private int plugin;

    public ViewInPluginCmd(TreeViewer model, int plugin) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.plugin = plugin;
    }

    @Override
    public void execute() {
        Browser browser = this.model.getSelectedBrowser();
        if (browser == null) {
            return;
        }
        TreeImageDisplay node = browser.getLastSelectedDisplay();
        if (node == null) {
            return;
        }
        Object object = node.getUserObject();
        if (object instanceof ImageData) {
            SecurityContext ctx = browser.getSecurityContext(node);
            ViewInPluginEvent event = new ViewInPluginEvent(ctx, (DataObject)object, this.plugin);
            event.setDataObjects(browser.getSelectedDataObjects());
            TreeViewerAgent.getRegistry().getEventBus().post(event);
        }
    }
}

