/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.treeviewer.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.DefaultTreeCellRenderer;
import omero.gateway.model.DataObject;
import omero.gateway.model.DatasetData;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.FileData;
import omero.gateway.model.GroupData;
import omero.gateway.model.ImageData;
import omero.gateway.model.PlateAcquisitionData;
import omero.gateway.model.PlateData;
import omero.gateway.model.ProjectData;
import omero.gateway.model.ScreenData;
import omero.gateway.model.TagAnnotationData;
import org.openmicroscopy.shoola.agents.treeviewer.IconManager;
import org.openmicroscopy.shoola.agents.treeviewer.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.agents.util.browser.SmartFolder;
import org.openmicroscopy.shoola.agents.util.browser.TreeFileSet;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageTimeSet;
import org.openmicroscopy.shoola.agents.util.dnd.DnDTree;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class TreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon IMAGE_ICON;
    private static final Icon IMAGE_ANNOTATED_ICON;
    private static final Icon IMAGE_NOT_OWNED_ICON;
    private static final Icon IMAGE_ANNOTATED_NOT_OWNED_ICON;
    private static final Icon IMAGE_UNREGISTERED_ICON;
    private static final Icon DATASET_ICON;
    private static final Icon DATASET_ANNOTATED_ICON;
    private static final Icon DATASET_TO_REFRESH_ICON;
    private static final Icon DATASET_ANNOTATED_TO_REFRESH_ICON;
    private static final Icon DATASET_NOT_OWNED_ICON;
    private static final Icon DATASET_ANNOTATED_NOT_OWNED_ICON;
    private static final Icon DATASET_TO_REFRESH_NOT_OWNED_ICON;
    private static final Icon DATASET_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON;
    private static final Icon PROJECT_NOT_OWNED_ICON;
    private static final Icon PROJECT_ANNOTATED_NOT_OWNED_ICON;
    private static final Icon PROJECT_TO_REFRESH_NOT_OWNED_ICON;
    private static final Icon PROJECT_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON;
    private static final Icon PROJECT_ICON;
    private static final Icon PROJECT_ANNOTATED_ICON;
    private static final Icon PROJECT_TO_REFRESH_ICON;
    private static final Icon PROJECT_ANNOTATED_TO_REFRESH_ICON;
    private static final Icon SCREEN_ICON;
    private static final Icon SCREEN_ANNOTATED_ICON;
    private static final Icon SCREEN_TO_REFRESH_ICON;
    private static final Icon SCREEN_ANNOTATED_TO_REFRESH_ICON;
    private static final Icon SCREEN_NOT_OWNED_ICON;
    private static final Icon SCREEN_ANNOTATED_NOT_OWNED_ICON;
    private static final Icon SCREEN_TO_REFRESH_NOT_OWNED_ICON;
    private static final Icon SCREEN_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON;
    private static final Icon PLATE_ICON;
    private static final Icon PLATE_ANNOTATED_ICON;
    private static final Icon PLATE_NOT_OWNED_ICON;
    private static final Icon PLATE_ANNOTATED_NOT_OWNED_ICON;
    private static final Icon PLATE_ACQUISITION_ICON;
    private static final Icon PLATE_ACQUISITION_ANNOTATED_ICON;
    private static final Icon TAG_ICON;
    private static final Icon TAG_SET_ICON;
    private static final Icon TAG_NOT_OWNED_ICON;
    private static final Icon TAG_SET_NOT_OWNED_ICON;
    private static final Icon PERSONAL_ICON;
    private static final Icon IMAGE_DIRECTORY_ICON;
    private static final Icon IMAGE_DIRECTORY_UNREGISTERED_ICON;
    private static final Icon DIRECTORY_ICON;
    private static final Icon DIRECTORY_REGISTERED_ICON;
    private static final Icon OWNER_ICON;
    private static final Icon OWNER_NOT_ACTIVE_ICON;
    private static final Icon ROOT_ICON;
    private static final Icon OWNER_TO_REFRESH_ICON;
    private static final Icon FILE_TEXT_ICON;
    private static final Icon FILE_PDF_ICON;
    private static final Icon FILE_HTML_ICON;
    private static final Icon FILE_PPT_ICON;
    private static final Icon FILE_WORD_ICON;
    private static final Icon FILE_EXCEL_ICON;
    private static final Icon FILE_XML_ICON;
    private static final Icon FILE_REGISTERED_ICON;
    private static final Icon MOVIE_ICON;
    private static final Icon MOVIE_FOLDER_ICON;
    private static final Icon DATE_ICON;
    private static final Icon OWNER_GROUP_ICON;
    private static final Icon GROUP_PRIVATE_ICON;
    private static final Icon GROUP_READ_ONLY_ICON;
    private static final Icon GROUP_READ_LINK_ICON;
    private static final Icon GROUP_READ_WRITE_ICON;
    private static final Icon GROUP_PUBLIC_READ_ICON;
    private static final Icon GROUP_PUBLIC_READ_WRITE_ICON;
    private static final Dimension SIZE;
    private boolean numberChildrenVisible;
    private boolean isTargetNode;
    private boolean droppedAllowed;
    private Color draggedColor;
    private boolean selected;
    private int xText;
    private long userId;
    private JScrollPane ref;
    private TreeImageDisplay node;

    private void setIcon(TreeImageDisplay node) {
        Object usrObject = node.getUserObject();
        boolean owner = false;
        if (usrObject instanceof DataObject) {
            DataObject data = (DataObject)usrObject;
            owner = data.getId() < 0L ? true : node.isOwner(this.userId);
        }
        owner = true;
        Icon icon = FILE_TEXT_ICON;
        if (usrObject instanceof ProjectData) {
            icon = node.isToRefresh() ? (owner ? (node.isAnnotated() ? PROJECT_ANNOTATED_TO_REFRESH_ICON : PROJECT_TO_REFRESH_ICON) : (node.isAnnotated() ? PROJECT_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON : PROJECT_TO_REFRESH_NOT_OWNED_ICON)) : (owner ? (node.isAnnotated() ? PROJECT_ANNOTATED_ICON : PROJECT_ICON) : (node.isAnnotated() ? PROJECT_ANNOTATED_NOT_OWNED_ICON : PROJECT_NOT_OWNED_ICON));
        } else if (usrObject instanceof DatasetData) {
            icon = node.isToRefresh() ? (owner ? (node.isAnnotated() ? DATASET_ANNOTATED_TO_REFRESH_ICON : DATASET_TO_REFRESH_ICON) : (node.isAnnotated() ? DATASET_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON : DATASET_TO_REFRESH_NOT_OWNED_ICON)) : (owner ? (node.isAnnotated() ? DATASET_ANNOTATED_ICON : DATASET_ICON) : (node.isAnnotated() ? DATASET_ANNOTATED_NOT_OWNED_ICON : DATASET_NOT_OWNED_ICON));
        } else if (usrObject instanceof ImageData) {
            ImageData o;
            icon = owner ? (node.isAnnotated() ? IMAGE_ANNOTATED_ICON : ((o = (ImageData)usrObject).getId() < 0L ? IMAGE_UNREGISTERED_ICON : IMAGE_ICON)) : (node.isAnnotated() ? IMAGE_ANNOTATED_NOT_OWNED_ICON : ((o = (ImageData)usrObject).getId() < 0L ? IMAGE_UNREGISTERED_ICON : IMAGE_NOT_OWNED_ICON));
        } else if (usrObject instanceof TagAnnotationData) {
            TagAnnotationData tag = (TagAnnotationData)usrObject;
            String ns = tag.getNameSpace();
            if ("openmicroscopy.org/omero/insight/tagset".equals(ns)) {
                icon = owner ? TAG_SET_ICON : TAG_SET_NOT_OWNED_ICON;
            } else {
                ExperimenterData exp;
                icon = TAG_ICON;
                TreeImageDisplay n = BrowserFactory.getDataOwner(node);
                if (n != null && !EditorUtil.isUserOwner(tag, (exp = (ExperimenterData)n.getUserObject()).getId())) {
                    icon = TAG_NOT_OWNED_ICON;
                }
            }
        } else if (usrObject instanceof ScreenData) {
            icon = node.isToRefresh() ? (owner ? (node.isAnnotated() ? SCREEN_ANNOTATED_TO_REFRESH_ICON : SCREEN_TO_REFRESH_ICON) : (node.isAnnotated() ? SCREEN_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON : SCREEN_TO_REFRESH_NOT_OWNED_ICON)) : (owner ? (node.isAnnotated() ? SCREEN_ANNOTATED_ICON : SCREEN_ICON) : (node.isAnnotated() ? SCREEN_ANNOTATED_NOT_OWNED_ICON : SCREEN_NOT_OWNED_ICON));
        } else if (usrObject instanceof PlateData) {
            icon = owner ? (node.isAnnotated() ? PLATE_ANNOTATED_ICON : PLATE_ICON) : (node.isAnnotated() ? PLATE_ANNOTATED_NOT_OWNED_ICON : PLATE_NOT_OWNED_ICON);
        } else if (usrObject instanceof PlateAcquisitionData) {
            icon = node.isAnnotated() ? PLATE_ACQUISITION_ANNOTATED_ICON : PLATE_ACQUISITION_ICON;
        } else if (usrObject instanceof GroupData) {
            GroupData g = (GroupData)usrObject;
            switch (g.getPermissions().getPermissionsLevel()) {
                case 0: {
                    icon = GROUP_PRIVATE_ICON;
                    break;
                }
                case 1: {
                    icon = GROUP_READ_ONLY_ICON;
                    break;
                }
                case 2: {
                    icon = GROUP_READ_LINK_ICON;
                    break;
                }
                case 3: {
                    icon = GROUP_READ_WRITE_ICON;
                    break;
                }
                case 4: {
                    icon = GROUP_PUBLIC_READ_ICON;
                    break;
                }
                case 5: {
                    icon = GROUP_PUBLIC_READ_WRITE_ICON;
                    break;
                }
                default: {
                    icon = OWNER_GROUP_ICON;
                    break;
                }
            }
        } else if (usrObject instanceof FileAnnotationData) {
            FileAnnotationData data = (FileAnnotationData)usrObject;
            String format = data.getFileFormat();
            icon = "pdf".equals(format) ? FILE_PDF_ICON : ("txt".equals(format) || "csv".equals(format) ? FILE_TEXT_ICON : ("html".equals(format) || "htm".equals(format) ? FILE_HTML_ICON : ("ppt".equals(format) || "pps".equals(format) || "pptx".equals(format) ? FILE_PPT_ICON : ("doc".equals(format) || "docx".equals(format) ? FILE_WORD_ICON : ("xls".equals(format) ? FILE_EXCEL_ICON : ("xml".equals(format) || "rtf".equals(format) ? FILE_XML_ICON : (data.isMovieFile() ? MOVIE_ICON : FILE_TEXT_ICON)))))));
        } else if (usrObject instanceof FileData) {
            FileData f = (FileData)usrObject;
            icon = f.isDirectory() ? (f.getId() > 0L ? DIRECTORY_REGISTERED_ICON : DIRECTORY_ICON) : (f.getId() > 0L ? FILE_REGISTERED_ICON : FILE_TEXT_ICON);
        } else if (node instanceof SmartFolder) {
            if (GroupData.class.equals((Object)((SmartFolder)node).getType())) {
                icon = PERSONAL_ICON;
            }
        } else if (node instanceof TreeImageTimeSet) {
            icon = DATE_ICON;
        } else if (node instanceof TreeFileSet) {
            TreeFileSet n = (TreeFileSet)node;
            switch (n.getType()) {
                case 2: {
                    icon = MOVIE_FOLDER_ICON;
                    break;
                }
                default: {
                    icon = ROOT_ICON;
                    break;
                }
            }
        } else if (usrObject instanceof String) {
            icon = ROOT_ICON;
        } else if (usrObject instanceof ExperimenterData) {
            ExperimenterData exp = (ExperimenterData)usrObject;
            icon = node.isToRefresh() ? OWNER_TO_REFRESH_ICON : (exp.isActive() ? OWNER_ICON : OWNER_NOT_ACTIVE_ICON);
        }
        this.setIcon(icon);
    }

    private void setTextColor(Color c) {
        if (c == null) {
            return;
        }
        if (UIUtilities.isDarkColor(c)) {
            this.setForeground(UIUtilities.DEFAULT_TEXT);
        }
    }

    public TreeCellRenderer(long userId, boolean b) {
        this.userId = userId;
        this.numberChildrenVisible = b;
        this.selected = false;
        this.draggedColor = new Color(this.backgroundSelectionColor.getRed(), this.backgroundSelectionColor.getGreen(), this.backgroundSelectionColor.getBlue(), 100);
    }

    public TreeCellRenderer(long userId) {
        this(userId, true);
    }

    public void reset(long userId) {
        this.userId = userId;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.isTargetNode = false;
        this.droppedAllowed = true;
        this.selected = sel;
        if (tree instanceof DnDTree) {
            DnDTree dndTree = (DnDTree)tree;
            boolean bl = this.isTargetNode = value == dndTree.getDropTargetNode();
            if (dndTree.getRowDropLocation() == row) {
                this.droppedAllowed = false;
            }
        }
        this.setIcon(FILE_TEXT_ICON);
        if (!(value instanceof TreeImageDisplay)) {
            return this;
        }
        this.node = (TreeImageDisplay)value;
        int w = 0;
        FontMetrics fm = this.getFontMetrics(this.getFont());
        Object ho = this.node.getUserObject();
        if (this.node.getLevel() == 0) {
            if (ho instanceof ExperimenterData) {
                this.setIcon(OWNER_ICON);
            } else {
                this.setIcon(ROOT_ICON);
            }
            if (this.getIcon() != null) {
                w += this.getIcon().getIconWidth();
            }
            w += this.getIconTextGap();
            this.setPreferredSize(new Dimension(w += fm.stringWidth(this.getText()), fm.getHeight()));
            Color c = this.node.getHighLight();
            if (c == null) {
                c = tree.getForeground();
            }
            this.setForeground(c);
            if (!sel) {
                this.setBorderSelectionColor(this.getBackground());
            } else {
                this.setTextColor(this.getBackgroundSelectionColor());
            }
            return this;
        }
        this.setIcon(this.node);
        this.setToolTipText(this.node.getToolTip());
        Color c = this.node.getHighLight();
        if (c == null) {
            c = tree.getForeground();
        }
        this.setForeground(c);
        if (!sel) {
            this.setBorderSelectionColor(this.getBackground());
        } else {
            this.setTextColor(this.getBackgroundSelectionColor());
        }
        w = this.getPreferredWidth();
        this.setPreferredSize(new Dimension(w, fm.getHeight() + 4));
        this.setEnabled(this.node.isSelectable());
        return this;
    }

    private int getPreferredWidth() {
        int w;
        String text = this.node.getNodeName();
        if (this.numberChildrenVisible) {
            text = this.node.getNodeText();
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        this.xText = w = this.getIconGap();
        w = this.node instanceof TreeFileSet ? (w += fm.stringWidth(text) + 40) : (w += fm.stringWidth(text));
        return w;
    }

    private int getIconGap() {
        int w = 0;
        w = this.getIcon() != null ? (w += this.getIcon().getIconWidth()) : (w += TreeCellRenderer.SIZE.width);
        return w += this.getIconTextGap();
    }

    @Override
    public String getText() {
        if (this.ref != null && !super.getText().equals("Loading...") && !super.getText().equals("Empty")) {
            JViewport vp = this.ref.getViewport();
            int w = vp.getSize().width;
            FontMetrics fm = this.getFontMetrics(this.getFont());
            String text = this.node.getNodeName();
            if (this.numberChildrenVisible) {
                text = this.node.getNodeText();
            }
            int v = this.getPreferredSize().width;
            Rectangle r = this.getBounds();
            if (v > (w -= r.x) && this.node.isPartialName()) {
                int targetWidth = w - this.getIconGap() - 5;
                String value = text;
                int l = text.length();
                int valueWidth = fm.stringWidth(value);
                while (valueWidth > targetWidth) {
                    if (l == 0) {
                        return "";
                    }
                    value = UIUtilities.formatPartialName(text, --l);
                    valueWidth = fm.stringWidth(value);
                }
                return value;
            }
            return text;
        }
        return super.getText();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.ref == null) {
            this.ref = (JScrollPane)UIUtilities.findParent(this, JScrollPane.class);
        }
        if (this.isTargetNode) {
            if (!this.droppedAllowed) {
                if (this.selected) {
                    g.setColor(this.backgroundSelectionColor);
                } else {
                    g.setColor(this.backgroundNonSelectionColor);
                }
            } else {
                g.setColor(this.draggedColor);
            }
            g.fillRect(this.xText, 0, this.getSize().width, this.getSize().height);
        }
        this.selected = false;
        this.isTargetNode = false;
        this.droppedAllowed = false;
        super.paintComponent(g);
    }

    static {
        IconManager icons = IconManager.getInstance();
        GROUP_PRIVATE_ICON = icons.getIcon(130);
        GROUP_READ_ONLY_ICON = icons.getIcon(131);
        GROUP_READ_LINK_ICON = icons.getIcon(132);
        GROUP_READ_WRITE_ICON = icons.getIcon(164);
        GROUP_PUBLIC_READ_ICON = icons.getIcon(133);
        GROUP_PUBLIC_READ_WRITE_ICON = icons.getIcon(133);
        OWNER_GROUP_ICON = icons.getIcon(152);
        IMAGE_ICON = icons.getIcon(6);
        IMAGE_ANNOTATED_ICON = icons.getIcon(19);
        IMAGE_NOT_OWNED_ICON = icons.getIcon(169);
        IMAGE_ANNOTATED_NOT_OWNED_ICON = icons.getIcon(168);
        IMAGE_UNREGISTERED_ICON = icons.getIcon(121);
        DATASET_NOT_OWNED_ICON = icons.getIcon(170);
        PROJECT_NOT_OWNED_ICON = icons.getIcon(171);
        SCREEN_NOT_OWNED_ICON = icons.getIcon(172);
        PLATE_NOT_OWNED_ICON = icons.getIcon(173);
        DATASET_ICON = icons.getIcon(5);
        PROJECT_ICON = icons.getIcon(4);
        SCREEN_ICON = icons.getIcon(75);
        PLATE_ICON = icons.getIcon(77);
        PROJECT_ANNOTATED_ICON = icons.getIcon(67);
        PROJECT_TO_REFRESH_ICON = icons.getIcon(148);
        PROJECT_ANNOTATED_NOT_OWNED_ICON = icons.getIcon(174);
        PROJECT_TO_REFRESH_NOT_OWNED_ICON = icons.getIcon(175);
        DATASET_ANNOTATED_ICON = icons.getIcon(18);
        DATASET_TO_REFRESH_ICON = icons.getIcon(146);
        DATASET_ANNOTATED_NOT_OWNED_ICON = icons.getIcon(176);
        DATASET_TO_REFRESH_NOT_OWNED_ICON = icons.getIcon(177);
        DATASET_ANNOTATED_TO_REFRESH_ICON = icons.getIcon(145);
        PROJECT_ANNOTATED_TO_REFRESH_ICON = icons.getIcon(147);
        DATASET_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON = icons.getIcon(178);
        PROJECT_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON = icons.getIcon(179);
        TAG_ICON = icons.getIcon(69);
        TAG_SET_ICON = icons.getIcon(71);
        TAG_NOT_OWNED_ICON = icons.getIcon(155);
        SCREEN_ANNOTATED_ICON = icons.getIcon(76);
        SCREEN_TO_REFRESH_ICON = icons.getIcon(150);
        SCREEN_ANNOTATED_TO_REFRESH_ICON = icons.getIcon(149);
        SCREEN_ANNOTATED_NOT_OWNED_ICON = icons.getIcon(180);
        SCREEN_TO_REFRESH_NOT_OWNED_ICON = icons.getIcon(181);
        SCREEN_ANNOTATED_TO_REFRESH_NOT_OWNED_ICON = icons.getIcon(182);
        PLATE_ANNOTATED_ICON = icons.getIcon(78);
        PLATE_ACQUISITION_ICON = icons.getIcon(114);
        PLATE_ANNOTATED_NOT_OWNED_ICON = icons.getIcon(183);
        PLATE_ACQUISITION_ANNOTATED_ICON = icons.getIcon(154);
        TAG_SET_NOT_OWNED_ICON = icons.getIcon(184);
        PERSONAL_ICON = icons.getIcon(112);
        IMAGE_DIRECTORY_ICON = icons.getIcon(126);
        IMAGE_DIRECTORY_UNREGISTERED_ICON = icons.getIcon(127);
        DIRECTORY_ICON = icons.getIcon(102);
        DIRECTORY_REGISTERED_ICON = icons.getIcon(119);
        OWNER_ICON = icons.getIcon(23);
        OWNER_NOT_ACTIVE_ICON = icons.getIcon(124);
        ROOT_ICON = icons.getIcon(7);
        OWNER_TO_REFRESH_ICON = icons.getIcon(10);
        FILE_TEXT_ICON = icons.getIcon(83);
        FILE_PDF_ICON = icons.getIcon(82);
        FILE_HTML_ICON = icons.getIcon(89);
        FILE_PPT_ICON = icons.getIcon(87);
        FILE_WORD_ICON = icons.getIcon(85);
        FILE_EXCEL_ICON = icons.getIcon(86);
        FILE_XML_ICON = icons.getIcon(88);
        FILE_REGISTERED_ICON = icons.getIcon(120);
        MOVIE_ICON = icons.getIcon(101);
        MOVIE_FOLDER_ICON = icons.getIcon(106);
        DATE_ICON = icons.getIcon(62);
        SIZE = new Dimension(16, 16);
    }
}

