/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.browser;

import java.util.Iterator;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplay;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.util.browser.TreeImageNode;

public class TreeImageSet
extends TreeImageDisplay {
    private Boolean childrenLoaded = null;
    private boolean system = false;

    @Override
    protected void doAccept(TreeImageDisplayVisitor visitor) {
        visitor.visit(this);
    }

    void setSystem(boolean system) {
        this.system = system;
    }

    public boolean isSystem() {
        return this.system;
    }

    public TreeImageSet(Object hierarchyObject) {
        super(hierarchyObject);
    }

    @Override
    public void addChildDisplay(TreeImageDisplay child) {
        if (child == null) {
            throw new NullPointerException("No child.");
        }
        super.addChildDisplay(child);
    }

    @Override
    public boolean containsImages() {
        if (this.childrenDisplay == null || this.childrenDisplay.size() == 0) {
            return false;
        }
        Iterator i = this.childrenDisplay.iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof TreeImageNode)) continue;
            return true;
        }
        return false;
    }

    public void setNumberItems(long value) {
        this.numberItems = value;
    }

    public long getNumberItems() {
        return this.numberItems;
    }

    @Override
    public boolean isChildrenLoaded() {
        if (this.childrenLoaded == null) {
            return false;
        }
        return this.childrenLoaded;
    }

    @Override
    public void setChildrenLoaded(Boolean childrenLoaded) {
        this.childrenLoaded = childrenLoaded;
    }

    @Override
    public TreeImageDisplay copy() {
        TreeImageSet copy = new TreeImageSet(this.getUserObject());
        copy.setChildrenLoaded(this.isChildrenLoaded());
        copy.setNumberItems(this.getNumberItems());
        copy.setHighLight(this.getHighLight());
        copy.setToolTip(this.getToolTip());
        copy.setExpanded(this.isExpanded());
        Iterator i = this.getChildrenDisplay().iterator();
        while (i.hasNext()) {
            copy.addChildDisplay(((TreeImageDisplay)i.next()).copy());
        }
        return copy;
    }

    @Override
    public boolean contains(TreeImageDisplay node) {
        if (node == null) {
            return false;
        }
        for (TreeImageDisplay child : this.getChildrenDisplay()) {
            if (child != node) continue;
            return true;
        }
        return false;
    }
}

