/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.util.finder;

import java.util.Collections;
import java.util.Set;
import omero.gateway.SecurityContext;
import omero.gateway.model.SearchParameters;
import org.openmicroscopy.shoola.agents.events.hiviewer.Browse;
import org.openmicroscopy.shoola.agents.util.finder.FinderLoader;
import org.openmicroscopy.shoola.agents.util.finder.QuickFinder;
import org.openmicroscopy.shoola.env.data.util.SearchResult;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public class QuickFinderLoader
extends FinderLoader {
    private SearchParameters context;
    private CallHandle handle;

    public QuickFinderLoader(QuickFinder viewer, SecurityContext ctx, SearchParameters context) {
        super(viewer, Collections.singletonList(ctx));
        if (context == null) {
            throw new IllegalArgumentException("No terms to search for.");
        }
        this.context = context;
    }

    @Override
    public void load() {
        this.handle = this.dhView.advancedSearchFor((SecurityContext)this.ctx.get(0), this.context, this);
    }

    @Override
    public void cancel() {
        this.handle.cancel();
    }

    @Override
    public void handleResult(Object result) {
        if (this.viewer.getState() == 100) {
            return;
        }
        EventBus bus = this.registry.getEventBus();
        SearchResult r = (SearchResult)result;
        if (r == null) {
            UserNotifier un = this.registry.getUserNotifier();
            un.notifyInfo("Search", "No results matching your criteria.");
            this.viewer.setStatus("", false);
            return;
        }
        Set<Long> set = r.getNodeIDs();
        if (set == null || set.size() == 0) {
            UserNotifier un = this.registry.getUserNotifier();
            un.notifyInfo("Search", "No results matching your criteria.");
            return;
        }
        Browse event = new Browse(set, 2, this.getUserDetails(), null);
        String s = " ";
        bus.post(event);
        this.viewer.dispose();
    }
}

