/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.config;

import org.openmicroscopy.shoola.env.config.ConfigException;
import org.openmicroscopy.shoola.env.config.Entry;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

class LongEntry
extends Entry {
    private Long value;

    LongEntry() {
    }

    @Override
    protected void setContent(Node node) throws ConfigException {
        String cfgVal = null;
        try {
            cfgVal = node.getFirstChild().getNodeValue();
            this.value = new Long(cfgVal);
        }
        catch (DOMException dex) {
            this.rethrow("Can't parse long entry, name: " + this.getName() + ".", dex);
        }
        catch (NumberFormatException nfe) {
            this.rethrow(cfgVal + " is not a valid long, entry name: " + this.getName() + ".", nfe);
        }
    }

    @Override
    Object getValue() {
        return this.value;
    }
}

