/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openmicroscopy.shoola.env.data.util.TransformsParser;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Target {
    static String SCHEMA = "schema";
    static String TARGET = "target";
    private static String TRANSFORM = "transform";
    private static String FILE = "file";
    private static String INFO = "info";
    private static String QUALITY = "quality";
    private String schema;
    private String quality;
    private String info;
    private List<String> transforms;
    private Element node;

    private void populate(Node node) throws Exception {
        NamedNodeMap map = node.getAttributes();
        for (int j = 0; j < map.getLength(); ++j) {
            Node attribute = map.item(j);
            if (!FILE.equals(attribute.getNodeName())) continue;
            this.transforms.add(attribute.getNodeValue());
        }
    }

    Target(Element node) {
        if (node == null) {
            throw new IllegalArgumentException("No node to handle.");
        }
        this.transforms = new ArrayList<String>();
        this.node = node;
    }

    void parse() throws Exception {
        int j;
        NamedNodeMap map = this.node.getAttributes();
        for (j = 0; j < map.getLength(); ++j) {
            Node attribute = map.item(j);
            if (INFO.equals(attribute.getNodeName())) {
                this.info = attribute.getNodeValue();
                continue;
            }
            if (QUALITY.equals(attribute.getNodeName())) {
                this.quality = attribute.getNodeValue();
                continue;
            }
            if (!SCHEMA.equals(attribute.getNodeName())) continue;
            this.schema = attribute.getNodeValue();
        }
        NodeList transforms = this.node.getElementsByTagName(TRANSFORM);
        for (j = 0; j < transforms.getLength(); ++j) {
            this.populate(transforms.item(j));
        }
    }

    public List<InputStream> getTransforms() {
        ArrayList<InputStream> styleSheets = new ArrayList<InputStream>();
        for (String name : this.transforms) {
            InputStream stream = !UIUtilities.isWindowsOS() ? this.getClass().getResourceAsStream("/" + TransformsParser.TRANSFORM_FOLDER + name) : this.getClass().getClassLoader().getResourceAsStream(TransformsParser.TRANSFORM_FOLDER + name);
            if (stream == null) continue;
            styleSheets.add(stream);
        }
        return styleSheets;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getQuality() {
        return this.quality;
    }

    public String getInformation() {
        return this.info;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.schema);
        if (this.quality != null) {
            buffer.append(" (quality:" + this.quality + ")");
        }
        return buffer.toString();
    }
}

