/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.env.data.views.calls;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import omero.gateway.SecurityContext;
import org.openmicroscopy.shoola.env.data.OmeroDataService;
import org.openmicroscopy.shoola.env.data.views.BatchCall;
import org.openmicroscopy.shoola.env.data.views.BatchCallTree;

public class PlateWellsLoader
extends BatchCallTree {
    private Object result;
    private BatchCall loadCall;
    private SecurityContext ctx;

    private BatchCall loadPlateWells(final Map<Long, Long> ids, final long userID) {
        return new BatchCall("Loading Plate Wells"){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = PlateWellsLoader.this.context.getDataService();
                HashMap<Long, Collection> r = new HashMap<Long, Collection>();
                for (Map.Entry entry : ids.entrySet()) {
                    long key = (Long)entry.getKey();
                    long value = (Long)entry.getValue();
                    r.put(key, os.loadPlateWells(PlateWellsLoader.this.ctx, key, value, userID));
                }
                PlateWellsLoader.this.result = r;
            }
        };
    }

    private BatchCall loadPlateFromImage(final Collection<Long> ids) {
        return new BatchCall("Loading Plate From Image"){

            @Override
            public void doCall() throws Exception {
                OmeroDataService os = PlateWellsLoader.this.context.getDataService();
                PlateWellsLoader.this.result = os.loadPlateFromImage(PlateWellsLoader.this.ctx, ids);
            }
        };
    }

    @Override
    protected void buildTree() {
        this.add(this.loadCall);
    }

    @Override
    protected Object getResult() {
        return this.result;
    }

    public PlateWellsLoader(SecurityContext ctx, Map<Long, Long> ids, long userID) {
        this.ctx = ctx;
        this.loadCall = this.loadPlateWells(ids, userID);
    }

    public PlateWellsLoader(SecurityContext ctx, Collection<Long> imageIDs) {
        this.ctx = ctx;
        this.loadCall = this.loadPlateFromImage(imageIDs);
    }
}

