/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.filter.file;

import java.io.File;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;

public class OpenDocumentFilter
extends CustomizedFileFilter {
    public static final String ODT = "odt";
    public static final String OTT = "ott";
    public static final String ODS = "ods";
    public static final String ODM = "odm";
    public static final String ODP = "odp";
    public static final String ODG = "odg";
    public static final String[] extensions = new String[6];
    private static final String description;

    @Override
    public String getMIMEType() {
        return "application/vnd.oasis.opendocument";
    }

    @Override
    public String getExtension() {
        return ODT;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public boolean accept(File f) {
        if (f == null) {
            return false;
        }
        if (f.isDirectory()) {
            return true;
        }
        return this.isSupported(f.getName(), extensions);
    }

    @Override
    public boolean accept(String fileName) {
        return this.isSupported(fileName, extensions);
    }

    static {
        OpenDocumentFilter.extensions[0] = ODT;
        OpenDocumentFilter.extensions[1] = OTT;
        OpenDocumentFilter.extensions[2] = ODS;
        OpenDocumentFilter.extensions[3] = ODM;
        OpenDocumentFilter.extensions[4] = ODP;
        OpenDocumentFilter.extensions[5] = ODG;
        StringBuffer s = new StringBuffer();
        s.append("Open Document Format (");
        for (int i = 0; i < extensions.length; ++i) {
            s.append("*." + extensions[i]);
            if (i >= extensions.length - 1) continue;
            s.append(", ");
        }
        s.append(")");
        description = s.toString();
    }
}

