/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.jhotdraw.draw.AbstractAttributedDecoratedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.FontSizeHandle;
import org.jhotdraw.draw.Handle;
import org.jhotdraw.draw.TextAreaTool;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.Tool;
import org.jhotdraw.geom.Insets2D;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.openmicroscopy.shoola.util.roi.figures.ROIFigure;
import org.openmicroscopy.shoola.util.roi.model.annotation.MeasurementAttributes;

public class MeasureTextArea
extends AbstractAttributedDecoratedFigure
implements TextHolderFigure {
    private Rectangle2D.Double bounds = new Rectangle2D.Double();
    private boolean editable = true;
    private transient TextLayout textLayout;

    public MeasureTextArea() {
        this("");
    }

    public MeasureTextArea(String text) {
        this.setText(text);
        this.setAttribute(MeasurementAttributes.FONT_FACE, ROIFigure.DEFAULT_FONT);
        this.setAttribute(MeasurementAttributes.FONT_SIZE, new Double(12.0));
    }

    protected void drawText(Graphics2D g) {
        if (this.getText() != null || this.isEditable()) {
            Font font = this.getFont();
            boolean isUnderlined = (Boolean)MeasurementAttributes.FONT_UNDERLINE.get((Figure)this);
            Insets2D.Double insets = this.getInsets();
            Rectangle2D.Double textRect = new Rectangle2D.Double(this.bounds.x + insets.left, this.bounds.y + insets.top, this.bounds.width - insets.left - insets.right, this.bounds.height - insets.top - insets.bottom);
            float leftMargin = (float)textRect.x;
            float rightMargin = (float)Math.max((double)(leftMargin + 1.0f), textRect.x + textRect.width);
            float verticalPos = (float)textRect.y;
            float maxVerticalPos = (float)(textRect.y + textRect.height);
            if (leftMargin < rightMargin) {
                float tabWidth = this.getTabSize() * g.getFontMetrics(font).charWidth('m');
                float[] tabStops = new float[(int)(textRect.width / (double)tabWidth)];
                for (int i = 0; i < tabStops.length; ++i) {
                    tabStops[i] = (float)(textRect.x + (double)((int)(tabWidth * (float)(i + 1))));
                }
                if (this.getText() != null) {
                    Shape savedClipArea = g.getClip();
                    g.clip(textRect);
                    String[] paragraphs = this.getText().split("\n");
                    for (int i = 0; i < paragraphs.length; ++i) {
                        if (paragraphs[i].length() == 0) {
                            paragraphs[i] = " ";
                        }
                        AttributedString as = new AttributedString(paragraphs[i]);
                        as.addAttribute(TextAttribute.FONT, font);
                        if (isUnderlined) {
                            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
                        }
                        int tabCount = new StringTokenizer(paragraphs[i], "\t").countTokens() - 1;
                        verticalPos = this.drawParagraph(g, as.getIterator(), verticalPos, maxVerticalPos, leftMargin, rightMargin, tabStops, tabCount);
                        if (verticalPos > maxVerticalPos) break;
                    }
                    g.setClip(savedClipArea);
                }
            }
            if (leftMargin >= rightMargin || (double)verticalPos > textRect.y + textRect.height) {
                // empty if block
            }
        }
    }

    private float drawParagraph(Graphics2D g, AttributedCharacterIterator styledText, float verticalPos, float maxVerticalPos, float leftMargin, float rightMargin, float[] tabStops, int tabCount) {
        int[] tabLocations = new int[tabCount + 1];
        int i = 0;
        char c = styledText.first();
        while (c != '\uffff') {
            if (c == '\t') {
                tabLocations[i++] = styledText.getIndex();
            }
            c = styledText.next();
        }
        tabLocations[tabCount] = styledText.getEndIndex() - 1;
        LineBreakMeasurer measurer = new LineBreakMeasurer(styledText, this.getFontRenderContext());
        int currentTab = 0;
        while (measurer.getPosition() < styledText.getEndIndex() && verticalPos <= maxVerticalPos) {
            boolean lineContainsText = false;
            boolean lineComplete = false;
            float maxAscent = 0.0f;
            float maxDescent = 0.0f;
            float horizontalPos = leftMargin;
            LinkedList<TextLayout> layouts = new LinkedList<TextLayout>();
            LinkedList<Float> penPositions = new LinkedList<Float>();
            while (!lineComplete && verticalPos <= maxVerticalPos) {
                float wrappingWidth = rightMargin - horizontalPos;
                TextLayout layout = null;
                layout = measurer.nextLayout(wrappingWidth, tabLocations[currentTab] + 1, lineContainsText);
                if (layout != null) {
                    layouts.add(layout);
                    penPositions.add(Float.valueOf(horizontalPos));
                    horizontalPos += layout.getAdvance();
                    maxAscent = Math.max(maxAscent, layout.getAscent());
                    maxDescent = Math.max(maxDescent, layout.getDescent() + layout.getLeading());
                } else {
                    lineComplete = true;
                }
                lineContainsText = true;
                if (measurer.getPosition() == tabLocations[currentTab] + 1) {
                    ++currentTab;
                }
                if (measurer.getPosition() == styledText.getEndIndex()) {
                    lineComplete = true;
                } else if (tabStops.length == 0 || horizontalPos >= tabStops[tabStops.length - 1]) {
                    lineComplete = true;
                }
                if (lineComplete) continue;
                int j = 0;
                while (horizontalPos >= tabStops[j]) {
                    ++j;
                }
                horizontalPos = tabStops[j];
            }
            verticalPos += maxAscent;
            Iterator layoutEnum = layouts.iterator();
            Iterator positionEnum = penPositions.iterator();
            while (layoutEnum.hasNext()) {
                TextLayout nextLayout = (TextLayout)layoutEnum.next();
                float nextPosition = ((Float)positionEnum.next()).floatValue();
                nextLayout.draw(g, nextPosition, verticalPos);
            }
            verticalPos += maxDescent;
        }
        return verticalPos;
    }

    protected void drawFill(Graphics2D g) {
        g.fill(this.bounds);
    }

    protected void drawStroke(Graphics2D g) {
    }

    public void basicSetBounds(Point2D.Double anchor, Point2D.Double lead) {
        this.bounds.x = Math.min(anchor.x, lead.x);
        this.bounds.y = Math.min(anchor.y, lead.y);
        this.bounds.width = Math.max(1.0, Math.abs(lead.x - anchor.x));
        this.bounds.height = Math.max(1.0, Math.abs(lead.y - anchor.y));
        this.textLayout = null;
    }

    public void basicTransform(AffineTransform tx) {
        Point2D.Double anchor = this.getStartPoint();
        Point2D.Double lead = this.getEndPoint();
        this.basicSetBounds((Point2D.Double)tx.transform(anchor, anchor), (Point2D.Double)tx.transform(lead, lead));
    }

    public boolean figureContains(Point2D.Double p) {
        return this.bounds.contains(p);
    }

    public Rectangle2D.Double getBounds() {
        return (Rectangle2D.Double)this.bounds.getBounds2D();
    }

    public void restoreTransformTo(Object geometry) {
        Rectangle2D.Double r = (Rectangle2D.Double)geometry;
        this.bounds.x = r.x;
        this.bounds.y = r.y;
        this.bounds.width = r.width;
        this.bounds.height = r.height;
    }

    public Object getTransformRestoreData() {
        return this.bounds.clone();
    }

    public String getText() {
        return (String)this.getAttribute(MeasurementAttributes.TEXT);
    }

    public Insets2D.Double getInsets() {
        double sw = Math.ceil((Double)MeasurementAttributes.STROKE_WIDTH.get((Figure)this) / 2.0);
        Insets2D.Double insets = new Insets2D.Double(4.0, 4.0, 4.0, 4.0);
        return new Insets2D.Double(insets.top + sw, insets.left + sw, insets.bottom + sw, insets.right + sw);
    }

    public int getTabSize() {
        return 8;
    }

    public void setText(String newText) {
        this.setAttribute(MeasurementAttributes.TEXT, newText);
    }

    public int getTextColumns() {
        return this.getText() == null ? 4 : Math.max(this.getText().length(), 4);
    }

    public Font getFont() {
        return AttributeKeys.getFont((Figure)this);
    }

    public Color getTextColor() {
        return (Color)MeasurementAttributes.TEXT_COLOR.get((Figure)this);
    }

    public Color getFillColor() {
        return (Color)MeasurementAttributes.FILL_COLOR.get((Figure)this);
    }

    public void setFontSize(float size) {
        MeasurementAttributes.FONT_SIZE.set((Figure)this, (Object)new Double(size));
    }

    public float getFontSize() {
        return ((Double)MeasurementAttributes.FONT_SIZE.get((Figure)this)).floatValue();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean b) {
        this.editable = b;
    }

    public Tool getTool(Point2D.Double p) {
        return this.isEditable() && this.contains(p) ? new TextAreaTool((TextHolderFigure)this) : null;
    }

    public TextHolderFigure getLabelFor() {
        return this;
    }

    public MeasureTextArea clone() {
        MeasureTextArea that = (MeasureTextArea)super.clone();
        that.bounds = (Rectangle2D.Double)this.bounds.clone();
        return that;
    }

    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList handles = (LinkedList)super.createHandles(detailLevel);
        if (detailLevel == 0) {
            handles.add(new FontSizeHandle((TextHolderFigure)this));
        }
        return handles;
    }

    protected void validate() {
        super.validate();
        this.textLayout = null;
    }

    protected void readBounds(DOMInput in) throws IOException {
        this.bounds.x = in.getAttribute("x", 0.0);
        this.bounds.y = in.getAttribute("y", 0.0);
        this.bounds.width = in.getAttribute("w", 0.0);
        this.bounds.height = in.getAttribute("h", 0.0);
    }

    protected void writeBounds(DOMOutput out) throws IOException {
        out.addAttribute("x", this.bounds.x);
        out.addAttribute("y", this.bounds.y);
        out.addAttribute("w", this.bounds.width);
        out.addAttribute("h", this.bounds.height);
    }

    public void read(DOMInput in) throws IOException {
        this.readBounds(in);
        this.readAttributes(in);
        this.textLayout = null;
    }

    public void write(DOMOutput out) throws IOException {
        this.writeBounds(out);
        this.writeAttributes(out);
    }

    public boolean isTextOverflow() {
        return false;
    }

    public void transform(AffineTransform tx) {
    }
}

