/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.roi.io;

import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.Line;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.TextRoi;
import ij.measure.ResultsTable;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.RoiManager;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import ome.formats.model.UnitsFactory;
import omero.gateway.model.EllipseData;
import omero.gateway.model.LineData;
import omero.gateway.model.PointData;
import omero.gateway.model.PolygonData;
import omero.gateway.model.PolylineData;
import omero.gateway.model.ROIData;
import omero.gateway.model.RectangleData;
import omero.gateway.model.ShapeData;
import omero.gateway.model.ShapeSettingsData;
import omero.gateway.model.TextData;
import omero.model.Image;
import omero.model.ImageI;
import omero.model.Length;
import omero.model.LengthI;
import org.openmicroscopy.shoola.util.CommonsLangUtils;

public class ROIReader {
    private static final String PRECISION = "precision";
    private static final String MEASUREMENTS = "measurements";

    private LineData convertLine(Line shape) {
        LineData r = new LineData(shape.x1d, shape.y1d, shape.x2d, shape.y2d);
        r.setText(shape.getName());
        if (this.formatShape((Roi)shape, r)) {
            return r;
        }
        return null;
    }

    private EllipseData convertEllipse(OvalRoi shape) {
        Rectangle bounds = shape.getBounds();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        EllipseData r = new EllipseData(bounds.getX() + width / 2.0, bounds.getY() + height / 2.0, width / 2.0, height / 2.0);
        r.setText(shape.getName());
        if (this.formatShape((Roi)shape, r)) {
            return r;
        }
        return null;
    }

    private RectangleData convertRectangle(Roi shape) {
        Rectangle bounds = shape.getBounds();
        RectangleData r = new RectangleData(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        r.setText(shape.getName());
        if (this.formatShape(shape, r)) {
            return r;
        }
        return null;
    }

    private void convertPoint(PointRoi shape, ROIData roi) {
        int[] xc = shape.getPolygon().xpoints;
        int[] yc = shape.getPolygon().ypoints;
        for (int i = 0; i < xc.length; ++i) {
            PointData p = new PointData(xc[i], yc[i]);
            p.setText(shape.getName());
            if (!this.formatShape((Roi)shape, p)) continue;
            roi.addShapeData(p);
        }
    }

    private ShapeData convertPolygon(PolygonRoi shape) {
        ShapeData data;
        int[] xc = shape.getPolygon().xpoints;
        int[] yc = shape.getPolygon().ypoints;
        String type = shape.getTypeAsString();
        LinkedList<Point2D.Double> points = new LinkedList<Point2D.Double>();
        for (int i = 0; i < xc.length; ++i) {
            points.add(new Point2D.Double(xc[i], yc[i]));
        }
        if (type.matches("Polyline") || type.matches("Freeline") || type.matches("Angle")) {
            data = new PolylineData(points);
            data.setText(shape.getName());
        } else if (type.matches("Polygon") || type.matches("Freehand") || type.matches("Traced")) {
            data = new PolygonData(points);
            ((PolygonData)data).setText(shape.getName());
        } else {
            data = new PolygonData(points);
            ((PolygonData)data).setText(shape.getName());
        }
        if (this.formatShape((Roi)shape, data)) {
            return data;
        }
        return null;
    }

    private TextData convertText(TextRoi shape) {
        Rectangle b = shape.getPolygon().getBounds();
        TextData data = new TextData(shape.getText(), b.getX(), b.getY());
        return data;
    }

    private boolean formatShape(Roi roi, ShapeData shape) {
        Color color;
        ShapeSettingsData settings = shape.getShapeSettings();
        if (roi.getStrokeWidth() > 0.0f) {
            settings.setStrokeWidth((Length)new LengthI((double)roi.getStrokeWidth(), UnitsFactory.Shape_StrokeWidth));
        }
        if (roi.getStrokeColor() != null) {
            color = roi.getStrokeColor();
            settings.setStroke(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        }
        if (roi.getFillColor() != null) {
            color = roi.getFillColor();
            settings.setFill(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        }
        int pos = roi.getPosition();
        int c = roi.getCPosition();
        int z = roi.getZPosition();
        int t = roi.getTPosition();
        ImagePlus image = roi.getImage();
        int imageC = 1;
        int imageT = 1;
        int imageZ = 1;
        if (image != null) {
            imageC = image.getNChannels();
            imageT = image.getNFrames();
            imageZ = image.getNSlices();
        }
        if (imageC == 1 && imageZ == 1) {
            shape.setC(0);
            shape.setZ(0);
            z = 0;
            c = 0;
            t = pos;
        } else if (imageZ == 1 && imageT == 1) {
            c = pos;
            z = 0;
            t = 0;
            shape.setZ(0);
            shape.setT(0);
        } else if (imageC == 1 && imageT == 1) {
            z = pos;
            t = 0;
            c = 0;
            shape.setC(0);
            shape.setT(0);
        }
        if (c > imageC || z > imageZ || t > imageT) {
            return false;
        }
        if (c != 0) {
            shape.setC(c - 1);
        }
        if (z != 0) {
            shape.setZ(z - 1);
        }
        if (t != 0) {
            shape.setT(t - 1);
        }
        return true;
    }

    private void setImage(Roi[] rois) {
        ImagePlus img = WindowManager.getCurrentImage();
        for (int i = 0; i < rois.length; ++i) {
            int id = rois[i].getImageID();
            if (id <= 0) {
                rois[i].setImage(img);
                continue;
            }
            rois[i].setImage(WindowManager.getImage((int)id));
        }
    }

    private List<ROIData> read(long imageID, Roi[] rois) {
        if (rois == null || rois.length == 0) {
            return null;
        }
        ArrayList<ROIData> pojos = new ArrayList<ROIData>();
        for (int i = 0; i < rois.length; ++i) {
            ShapeData shape;
            Roi r = rois[i];
            ROIData roiData = new ROIData();
            String type = r.getTypeAsString();
            if (imageID >= 0L) {
                roiData.setImage((Image)new ImageI(imageID, false));
            }
            pojos.add(roiData);
            if (r.isDrawingTool()) {
                if (type.matches("Text")) {
                    roiData.addShapeData(this.convertText((TextRoi)r));
                    continue;
                }
                if (!type.matches("Rectangle") || (shape = this.convertRectangle(r)) == null) continue;
                roiData.addShapeData(shape);
                continue;
            }
            if (r instanceof OvalRoi) {
                shape = this.convertEllipse((OvalRoi)r);
                if (shape == null) continue;
                roiData.addShapeData(shape);
                continue;
            }
            if (r instanceof Line) {
                shape = this.convertLine((Line)r);
                if (shape == null) continue;
                roiData.addShapeData(shape);
                continue;
            }
            if (r instanceof PolygonRoi || r instanceof EllipseRoi) {
                if (type.matches("Point")) {
                    this.convertPoint((PointRoi)r, roiData);
                    continue;
                }
                if (!type.matches("Polyline") && !type.matches("Freeline") && !type.matches("Angle") && !type.matches("Polygon") && !type.matches("Freehand") && !type.matches("Traced") && !type.matches("Oval") || (shape = this.convertPolygon((PolygonRoi)r)) == null) continue;
                roiData.addShapeData(shape);
                continue;
            }
            if (r instanceof ShapeRoi) {
                Roi[] subRois = ((ShapeRoi)r).getRois();
                for (int j = 0; j < subRois.length; ++j) {
                    Roi shapeij = subRois[j];
                    ImagePlus imp = r.getImage();
                    shapeij.setImage(imp);
                    int pos = r.getPosition();
                    int c = r.getCPosition();
                    int z = r.getZPosition();
                    int t = r.getTPosition();
                    if (imp.getNChannels() == 1 && imp.getNSlices() == 1) {
                        shapeij.setPosition(pos);
                    } else if (imp.getNChannels() == 1 && imp.getNFrames() == 1) {
                        shapeij.setPosition(pos);
                    } else if (imp.getNSlices() == 1 && imp.getNFrames() == 1) {
                        shapeij.setPosition(pos);
                    } else if (imp.isHyperStack()) {
                        shapeij.setPosition(c, z, t);
                    }
                    type = shapeij.getTypeAsString();
                    if (shapeij instanceof Line) {
                        shape = this.convertLine((Line)shapeij);
                        if (shape == null) continue;
                        roiData.addShapeData(shape);
                        continue;
                    }
                    if (shapeij instanceof OvalRoi) {
                        shape = this.convertEllipse((OvalRoi)shapeij);
                        if (shape == null) continue;
                        roiData.addShapeData(shape);
                        continue;
                    }
                    if (!(shapeij instanceof PolygonRoi) && !(r instanceof EllipseRoi)) continue;
                    if (type.matches("Point")) {
                        this.convertPoint((PointRoi)shapeij, roiData);
                        continue;
                    }
                    if (!type.matches("Polyline") && !type.matches("Freeline") && !type.matches("Angle") && !type.matches("Polygon") && !type.matches("Freehand") && !type.matches("Traced") && !type.matches("Oval") || (shape = this.convertPolygon((PolygonRoi)shapeij)) == null) continue;
                    roiData.addShapeData(shape);
                }
                continue;
            }
            if (!type.matches("Rectangle") || (shape = this.convertRectangle(r)) == null) continue;
            roiData.addShapeData(shape);
        }
        return pojos;
    }

    public List<ROIData> readImageJROI(long imageID, ImagePlus image) {
        Roi[] rois;
        if (image == null) {
            return null;
        }
        Overlay overlay = image.getOverlay();
        if (overlay != null) {
            Roi[] rois2;
            for (Roi roi : rois2 = overlay.toArray()) {
                roi.setImage(image);
            }
            return this.read(imageID, rois2);
        }
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            return null;
        }
        for (Roi roi : rois = manager.getRoisAsArray()) {
            roi.setImage(image);
        }
        return this.read(imageID, rois);
    }

    public List<ROIData> readImageJROI(long imageID) {
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            return null;
        }
        Roi[] rois = manager.getRoisAsArray();
        this.setImage(rois);
        return this.read(imageID, rois);
    }

    public List<ROIData> readImageJROIFromSources(long imageID, ImagePlus image) {
        if (image == null) {
            return null;
        }
        Overlay overlay = image.getOverlay();
        if (overlay != null) {
            Roi[] rois = overlay.toArray();
            for (int i = 0; i < rois.length; ++i) {
                rois[i].setImage(image);
            }
            return this.read(imageID, rois);
        }
        return this.readImageJROI(imageID, image);
    }

    public List<ROIData> readImageJROI() {
        RoiManager manager = RoiManager.getInstance();
        if (manager == null) {
            return null;
        }
        Roi[] rois = manager.getRoisAsArray();
        this.setImage(rois);
        return this.read(-1L, rois);
    }

    public void readROIMeasurement(File f) throws IOException {
        if (f == null) {
            return;
        }
        this.readROIMeasurement(f.getAbsolutePath());
    }

    public void readROIMeasurement(String f) throws IOException {
        if (CommonsLangUtils.isBlank(f)) {
            return;
        }
        int totint = 3116051;
        int precision = Prefs.getInt((String)PRECISION, (int)5);
        RoiManager.getInstance().runCommand("Measure");
        Analyzer.setMeasurement((int)Prefs.getInt((String)MEASUREMENTS, (int)totint), (boolean)true);
        Analyzer.setPrecision((int)precision);
        ResultsTable rt = Analyzer.getResultsTable();
        rt.updateResults();
        rt.show("Results");
        rt.saveAs(f);
    }

    public boolean readResults(File f) throws IOException {
        if (f == null) {
            return false;
        }
        return this.readResults(f.getAbsolutePath());
    }

    public boolean readResults(String f) throws IOException {
        ResultsTable rt = ResultsTable.getResultsTable();
        if (rt == null || rt.getCounter() == 0) {
            return false;
        }
        rt.updateResults();
        rt.saveAs(f);
        return true;
    }
}

