/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;

public class HistoryDialog
extends JPopupMenu {
    public static final String SELECTION_PROPERTY = "selection";
    private static final int MAX_HEIGHT = 200;
    private JList history;
    private JList secondaryHistory;
    private int width;
    private Object[] data;
    private Object[] originalData;
    private Object[] secondaryData;
    private Object[] secondaryOriginalData;
    private FontMetrics metrics;
    private boolean caseSensitive;

    private void determinePopupSize() {
        int height = this.metrics.getHeight() * this.data.length + 10;
        if (this.secondaryHistory != null) {
            height += this.metrics.getHeight() * this.secondaryData.length + 10;
        }
        if (height > 200) {
            height = 200;
        }
        this.setPopupSize(new Dimension(this.width, height));
    }

    private void buildGUI() {
        JPanel list;
        list.setOpaque(!(list = new JPanel()).isOpaque());
        if (this.secondaryHistory == null) {
            list.setLayout(new BorderLayout());
            list.add(this.history);
        } else {
            double[][] tl = new double[][]{{-1.0}, {-2.0, -2.0, -2.0}};
            list.setLayout((LayoutManager)new TableLayout((double[][])tl));
            list.add((Component)this.history, "0, 0");
            list.add((Component)new JSeparator(), "0, 1");
            list.add((Component)this.secondaryHistory, "0, 2");
        }
        this.metrics = this.getFontMetrics(this.history.getFont());
        this.determinePopupSize();
        this.add(new JScrollPane(list));
    }

    private void initComponents() {
        this.caseSensitive = false;
        this.history = new JList<Object>(this.data);
        this.history.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ListSelectionModel model = HistoryDialog.this.history.getSelectionModel();
                if (model.isSelectionEmpty()) {
                    return;
                }
                int index = HistoryDialog.this.history.getSelectedIndex();
                HistoryDialog.this.firePropertyChange(HistoryDialog.SELECTION_PROPERTY, null, HistoryDialog.this.data[index]);
                HistoryDialog.this.setVisible(false);
            }
        });
        if (this.secondaryData == null || this.secondaryData.length == 0) {
            return;
        }
        this.secondaryHistory = new JList<Object>(this.secondaryData);
        this.secondaryHistory.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ListSelectionModel model = HistoryDialog.this.secondaryHistory.getSelectionModel();
                if (model.isSelectionEmpty()) {
                    return;
                }
                int index = HistoryDialog.this.secondaryHistory.getSelectedIndex();
                HistoryDialog.this.firePropertyChange(HistoryDialog.SELECTION_PROPERTY, null, HistoryDialog.this.secondaryData[index]);
                HistoryDialog.this.setVisible(false);
            }
        });
    }

    public HistoryDialog(Object[] data, int width) {
        this.originalData = data;
        this.data = data;
        this.width = width;
        this.initComponents();
        this.buildGUI();
    }

    public HistoryDialog(Object[] data, Object[] secondaryData, int width) {
        this.originalData = data;
        this.data = data;
        this.width = width;
        this.secondaryData = secondaryData;
        this.secondaryOriginalData = secondaryData;
        this.initComponents();
        this.buildGUI();
    }

    public void setListCellRenderer(DefaultListCellRenderer rnd) {
        if (rnd != null) {
            this.history.setCellRenderer(rnd);
        }
    }

    public void setListCellRenderer(DefaultListCellRenderer rndMain, DefaultListCellRenderer rnd) {
        if (rndMain != null) {
            this.history.setCellRenderer(rndMain);
        }
        if (rnd != null && this.secondaryHistory != null) {
            this.secondaryHistory.setCellRenderer(rnd);
        }
    }

    public Object getSelectedTextValue() {
        ListSelectionModel model = this.history.getSelectionModel();
        if (!model.isSelectionEmpty()) {
            int index = this.history.getSelectedIndex();
            this.setVisible(false);
            return this.data[index];
        }
        if (this.secondaryHistory != null && !(model = this.secondaryHistory.getSelectionModel()).isSelectionEmpty()) {
            int index = this.secondaryHistory.getSelectedIndex();
            this.setVisible(false);
            return this.secondaryData[index];
        }
        return null;
    }

    public boolean setSelectedTextValue(String v) {
        String value;
        if (v == null || v.length() == 0) {
            return false;
        }
        if (this.originalData == null) {
            return false;
        }
        if (!this.caseSensitive) {
            v = v.toLowerCase();
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < this.originalData.length; ++i) {
            value = this.originalData[i].toString();
            if (!this.caseSensitive) {
                value = value.toLowerCase();
            }
            if (!value.startsWith(v)) continue;
            l.add(this.originalData[i]);
        }
        if (this.secondaryHistory != null) {
            ArrayList<Object> sl = new ArrayList<Object>();
            for (int i = 0; i < this.secondaryOriginalData.length; ++i) {
                value = this.secondaryOriginalData[i].toString();
                if (!this.caseSensitive) {
                    value = value.toLowerCase();
                }
                if (!value.startsWith(v)) continue;
                sl.add(this.secondaryOriginalData[i]);
            }
            int n = sl.size();
            int m = l.size();
            if (n == 0 && m == 0) {
                this.resetListData();
                return false;
            }
            if (n == 0 && m > 0) {
                this.data = new Object[m];
                Iterator j = l.iterator();
                int index = 0;
                while (j.hasNext()) {
                    this.data[index] = j.next();
                    ++index;
                }
                this.history.setListData(this.data);
                this.history.setSelectedValue(this.data[0], true);
                this.secondaryData = new Object[n];
                this.secondaryHistory.setListData(this.secondaryData);
                this.determinePopupSize();
                return true;
            }
            if (n > 0 && m == 0) {
                this.secondaryData = new Object[n];
                Iterator j = sl.iterator();
                int index = 0;
                while (j.hasNext()) {
                    this.secondaryData[index] = j.next();
                    ++index;
                }
                this.secondaryHistory.setListData(this.secondaryData);
                this.secondaryHistory.setSelectedValue(this.secondaryData[0], true);
                this.data = new Object[m];
                this.history.setListData(this.data);
                this.determinePopupSize();
                return true;
            }
            if (n > 0 && m > 0) {
                this.data = new Object[m];
                Iterator j = l.iterator();
                int index = 0;
                while (j.hasNext()) {
                    this.data[index] = j.next();
                    ++index;
                }
                this.history.setListData(this.data);
                this.history.setSelectedValue(this.data[0], true);
                this.secondaryData = new Object[n];
                j = sl.iterator();
                index = 0;
                while (j.hasNext()) {
                    this.secondaryData[index] = j.next();
                    ++index;
                }
                this.secondaryHistory.setListData(this.secondaryData);
                this.determinePopupSize();
                return true;
            }
        } else {
            if (l.size() == 0) {
                this.resetListData();
                return false;
            }
            this.data = new Object[l.size()];
            Iterator j = l.iterator();
            int index = 0;
            while (j.hasNext()) {
                this.data[index] = j.next();
                ++index;
            }
            this.history.setListData(this.data);
            this.history.setSelectedValue(this.data[0], true);
            this.determinePopupSize();
            return true;
        }
        return false;
    }

    public void setSelectedIndex(boolean increase) {
        ListSelectionModel model = this.history.getSelectionModel();
        int m = this.data.length;
        if (this.secondaryHistory == null) {
            if (m > 0) {
                int index = model.isSelectionEmpty() ? 0 : this.history.getSelectedIndex();
                Object r = null;
                int l = m - 1;
                index = increase ? (index < l ? ++index : 0) : (index > 0 ? --index : l);
                r = this.data[index];
                if (r != null) {
                    this.history.setSelectedValue(r, true);
                }
            }
        } else {
            int n = this.secondaryData.length;
            if (n == 0 && m == 0) {
                return;
            }
            if (n == 0 && m > 0) {
                if (!model.isSelectionEmpty()) {
                    int index = this.history.getSelectedIndex();
                    Object r = null;
                    int l = m - 1;
                    index = increase ? (index < l ? ++index : 0) : (index > 0 ? --index : l);
                    r = this.data[index];
                    if (r != null) {
                        this.history.setSelectedValue(r, true);
                    }
                }
            } else if (n > 0 && m == 0) {
                model = this.secondaryHistory.getSelectionModel();
                if (!model.isSelectionEmpty()) {
                    int index = this.secondaryHistory.getSelectedIndex();
                    Object r = null;
                    int l = n - 1;
                    index = increase ? (index < l ? ++index : 0) : (index > 0 ? --index : l);
                    r = this.secondaryData[index];
                    if (r != null) {
                        this.secondaryHistory.setSelectedValue(r, true);
                    }
                }
            } else if (n > 0 && m > 0) {
                ListSelectionModel msh = this.secondaryHistory.getSelectionModel();
                if (!model.isSelectionEmpty()) {
                    int index = this.history.getSelectedIndex();
                    int l = m - 1;
                    if (increase) {
                        if (index < l) {
                            this.history.setSelectedValue(this.data[++index], true);
                        } else {
                            model.clearSelection();
                            index = 0;
                            this.secondaryHistory.setSelectedValue(this.secondaryData[0], true);
                        }
                    } else if (index > 0) {
                        this.history.setSelectedValue(this.data[--index], true);
                    } else {
                        model.clearSelection();
                        index = n - 1;
                        this.secondaryHistory.setSelectedValue(this.secondaryData[index], true);
                    }
                } else {
                    if (msh.isSelectionEmpty()) {
                        return;
                    }
                    int l = n - 1;
                    int index = this.secondaryHistory.getSelectedIndex();
                    if (increase) {
                        if (index < l) {
                            this.secondaryHistory.setSelectedValue(this.secondaryData[++index], true);
                        } else {
                            index = 0;
                            msh.clearSelection();
                            this.history.setSelectedValue(this.data[0], true);
                        }
                    } else if (index > 0) {
                        this.secondaryHistory.setSelectedValue(this.secondaryData[--index], true);
                    } else {
                        index = m - 1;
                        this.secondaryHistory.clearSelection();
                        this.history.setSelectedValue(this.data[index], true);
                    }
                }
            }
        }
    }

    public void resetListData() {
        if (this.originalData == null || this.originalData.length == 0) {
            return;
        }
        this.data = this.originalData;
        this.history.setListData(this.originalData);
        this.history.setSelectedValue(this.originalData[0], true);
        if (this.secondaryHistory != null) {
            this.secondaryData = this.secondaryOriginalData;
            this.secondaryHistory.setListData(this.secondaryOriginalData);
        }
        this.determinePopupSize();
    }
}

