/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class JXTaskPaneContainerSingle
extends JXTaskPaneContainer
implements PropertyChangeListener {
    public static final String SELECTED_TASKPANE_PROPERTY = "selectedTaskPane";
    private Map<JXTaskPane, Integer> panes;
    private boolean expandable;
    private GridBagLayout layout = new GridBagLayout();

    private void initialize() {
        this.expandable = true;
        this.panes = new HashMap<JXTaskPane, Integer>();
        this.setLayout(this.layout);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBackground(UIUtilities.BACKGROUND);
    }

    public JXTaskPaneContainerSingle() {
        this.initialize();
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public boolean hasTaskPaneExpanded() {
        Component[] comps = this.getComponents();
        if (comps == null) {
            return false;
        }
        for (int i = 0; i < comps.length; ++i) {
            JXTaskPane pane;
            if (!(comps[i] instanceof JXTaskPane) || (pane = (JXTaskPane)comps[i]).isCollapsed()) continue;
            return true;
        }
        return false;
    }

    private int getTaskPaneExpandedCount() {
        Component[] comps = this.getComponents();
        if (comps == null) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < comps.length; ++i) {
            JXTaskPane pane;
            if (!(comps[i] instanceof JXTaskPane) || (pane = (JXTaskPane)comps[i]).isCollapsed()) continue;
            ++count;
        }
        return count;
    }

    public List<JXTaskPane> getTaskPanes() {
        ArrayList<JXTaskPane> list = new ArrayList<JXTaskPane>();
        Iterator<JXTaskPane> iterator = this.panes.keySet().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public void add(JXTaskPane component) {
        component.setAnimated(false);
        int index = this.panes.size();
        this.panes.put(component, index);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = index;
        c.fill = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 11;
        super.add((Component)component, (Object)c);
        component.addPropertyChangeListener("collapsed", (PropertyChangeListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        JXTaskPane src = (JXTaskPane)evt.getSource();
        if (!this.expandable) {
            src.setCollapsed(true);
            src.setSpecial(false);
            return;
        }
        Container parent = src.getParent();
        Component[] comp = parent.getComponents();
        if (src.isCollapsed()) {
            if (this.getTaskPaneExpandedCount() < 2) {
                return;
            }
            for (int i = 0; i < comp.length; ++i) {
                JXTaskPane p;
                Component c = comp[i];
                if (!(c instanceof JXTaskPane) || (p = (JXTaskPane)c) != src) continue;
                GridBagConstraints con = this.layout.getConstraints((Component)p);
                con.fill = 2;
                con.weighty = 0.0;
                this.layout.setConstraints((Component)p, con);
            }
            this.firePropertyChange(SELECTED_TASKPANE_PROPERTY, null, src);
            return;
        }
        for (int i = 0; i < comp.length; ++i) {
            GridBagConstraints con;
            Component c = comp[i];
            if (!(c instanceof JXTaskPane)) continue;
            JXTaskPane p = (JXTaskPane)c;
            if (p != src) {
                p.setCollapsed(true);
                p.setSpecial(false);
                con = this.layout.getConstraints((Component)p);
                con.fill = 2;
                con.weighty = 0.0;
                this.layout.setConstraints((Component)p, con);
                continue;
            }
            con = this.layout.getConstraints((Component)p);
            con.fill = 1;
            con.weighty = 1.0;
            this.layout.setConstraints((Component)p, con);
        }
        src.setSpecial(true);
        this.firePropertyChange(SELECTED_TASKPANE_PROPERTY, null, src);
    }
}

