/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.colourpicker;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.util.CommonsLangUtils;
import org.openmicroscopy.shoola.util.ui.colourpicker.ColourChangedEvent;
import org.openmicroscopy.shoola.util.ui.colourpicker.RGBModel;

class RGBControl
extends JComponent {
    public static Map<String, Color> PREDEFINED_COLORS = new LinkedHashMap<String, Color>();
    private RGBModel model;
    private List<ChangeListener> listeners;

    RGBControl(RGBModel m) {
        if (m == null) {
            throw new NullPointerException("No model.");
        }
        this.model = m;
        this.listeners = new ArrayList<ChangeListener>();
    }

    boolean isCustomColor() {
        if (CommonsLangUtils.isNotEmpty(this.getLUT())) {
            return false;
        }
        Color c = this.getColour();
        for (Color c2 : PREDEFINED_COLORS.values()) {
            if (c2.getRed() != c.getRed() || c2.getBlue() != c.getBlue() || c2.getGreen() != c.getGreen()) continue;
            return false;
        }
        return true;
    }

    void setRed(float r) {
        this.model.setRed(r);
        this.fireChangeEvent();
    }

    void setBlue(float b) {
        this.model.setBlue(b);
        this.fireChangeEvent();
    }

    void setGreen(float g) {
        this.model.setGreen(g);
        this.fireChangeEvent();
    }

    void setAlpha(float a) {
        this.model.setAlpha(a);
        this.fireChangeEvent();
    }

    void setHue(float h) {
        this.model.setHue(h);
        this.fireChangeEvent();
    }

    void setSaturation(float s) {
        this.model.setSaturation(s);
        this.fireChangeEvent();
    }

    void setValue(float v) {
        this.model.setValue(v);
        this.fireChangeEvent();
    }

    void setColour(Color c) {
        this.model.setColour(c);
        this.fireChangeEvent();
    }

    void setHSVColour(float h, float s, float v, float a) {
        this.model.setHSVColour(h, s, v, a);
        this.fireChangeEvent();
    }

    void setRGBColour(float r, float g, float b, float a) {
        this.model.setRGBColour(r, g, b, a);
        this.fireChangeEvent();
    }

    void revert() {
        this.model.revert();
        this.fireChangeEvent();
    }

    Color getColour() {
        return this.model.getColour();
    }

    boolean isOriginalColour() {
        return this.model.isOriginalColor(this.getColour());
    }

    float getRed() {
        return this.model.getRed();
    }

    float getGreen() {
        return this.model.getGreen();
    }

    float getBlue() {
        return this.model.getBlue();
    }

    float getAlpha() {
        return this.model.getAlpha();
    }

    float getHue() {
        return this.model.getHue();
    }

    float getSaturation() {
        return this.model.getSaturation();
    }

    float getValue() {
        return this.model.getValue();
    }

    void setLUT(String lut) {
        this.model.setLUT(lut);
        this.fireChangeEvent("lut");
    }

    String getLUT() {
        return this.model.getLUT();
    }

    void setReverseIntensity(boolean revInt) {
        this.model.setReverseIntensity(revInt);
        this.fireChangeEvent(null);
    }

    boolean getReverseIntensity() {
        return this.model.getReverseIntensity();
    }

    boolean isOriginalLut() {
        return this.model.isOriginalLut(this.getLUT());
    }

    boolean isOriginalRevInt() {
        return this.model.getOriginalReverseIntensity() == this.getReverseIntensity();
    }

    Collection<String> getAvailableLookupTables() {
        return this.model.getAvailableLookupTables();
    }

    void addListener(ChangeListener e) {
        this.listeners.add(e);
    }

    void fireChangeEvent() {
        this.fireChangeEvent("colourChanged");
    }

    void fireChangeEvent(String property) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ChangeListener e = this.listeners.get(i);
            e.stateChanged(new ColourChangedEvent(this));
        }
        if ("lut".equals(property)) {
            this.firePropertyChange("lut", null, this.model.getLUT());
        } else if ("colourChanged".equals(property)) {
            this.firePropertyChange("colourChanged", null, this.model.getColour());
        }
    }

    static {
        PREDEFINED_COLORS.put("Red", Color.red);
        PREDEFINED_COLORS.put("Green", Color.green);
        PREDEFINED_COLORS.put("Blue", Color.blue);
        PREDEFINED_COLORS.put("White", Color.white);
        PREDEFINED_COLORS.put("Black", Color.black);
        PREDEFINED_COLORS.put("Gray", Color.gray);
        PREDEFINED_COLORS.put("Orange", Color.orange);
        PREDEFINED_COLORS.put("Yellow", Color.yellow);
        PREDEFINED_COLORS.put("Indigo", new Color(75, 0, 130));
        PREDEFINED_COLORS.put("Violet", new Color(238, 130, 238));
        PREDEFINED_COLORS.put("Cyan", Color.cyan);
        PREDEFINED_COLORS.put("Magenta", Color.magenta);
    }
}

