/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.drawingtools.figures;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;

public class FigureUtil {
    public static final String RECTANGLE_TYPE = "Rectangle";
    public static final String ELLIPSE_TYPE = "Ellipse";
    public static final String POINT_TYPE = "Point";
    public static final String LINE_TYPE = "Line";
    public static final String ARROW_TYPE = "Arrow";
    public static final String LINE_CONNECTION_TYPE = "LineConnection";
    public static final String POLYGON_TYPE = "Polygon";
    public static final String TEXT_TYPE = "Text";
    public static final String SCRIBBLE_TYPE = "Scribble";
    public static final String MASK_TYPE = "Mask";
    static final int TEXT_COLUMNS = 4;
    static final int TAB_SIZE = 8;
    static final int TEXT_WIDTH = 100;
    static final Color TEXT_COLOR = Color.BLACK;

    static TextLayout createLayout(String text, FontRenderContext frc, Font f, boolean underlined) {
        if (text == null || text.trim().length() == 0) {
            text = " ";
        }
        HashMap<TextAttribute, Serializable> textAttributes = new HashMap<TextAttribute, Serializable>();
        textAttributes.put(TextAttribute.FONT, f);
        textAttributes.put(TextAttribute.SIZE, Integer.valueOf(40));
        if (underlined) {
            textAttributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
        TextLayout layout = new TextLayout(text, textAttributes, frc);
        return layout;
    }

    static void formatLayout(Font f, AttributedString styledText, Figure figure) {
        if (styledText == null) {
            return;
        }
        if (f != null) {
            styledText.addAttribute(TextAttribute.FONT, f);
        }
        if (figure != null && ((Boolean)AttributeKeys.FONT_UNDERLINE.get(figure)).booleanValue()) {
            styledText.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
    }
}

