/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.lens;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.openmicroscopy.shoola.util.ui.lens.LensComponent;
import org.openmicroscopy.shoola.util.ui.lens.LensUI;

class LensColorAction
extends AbstractAction {
    static final int MAX = 12;
    static final int DEFAULT = 0;
    static final int RED = 1;
    static final int ORANGE = 2;
    static final int YELLOW = 3;
    static final int GREEN = 4;
    static final int BLUE = 5;
    static final int INDIGO = 6;
    static final int VIOLET = 7;
    static final int BLACK = 8;
    static final int LIGHT_GRAY = 9;
    static final int DARK_GRAY = 10;
    static final int WHITE = 11;
    private LensComponent lens;
    private int index;
    private static String[] names = new String[12];
    private static Color[] colors;

    private void checkIndex(int i) {
        switch (i) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return;
            }
        }
        throw new IllegalArgumentException("Index not supported.");
    }

    LensColorAction(LensComponent lens, int displayIndex) {
        if (lens == null) {
            throw new IllegalArgumentException("No parent.");
        }
        this.lens = lens;
        this.checkIndex(displayIndex);
        this.index = displayIndex;
        this.putValue("Name", names[this.index]);
    }

    Color getColor() {
        return colors[this.index];
    }

    String getName() {
        return names[this.index];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.lens.setLensColour(colors[this.index]);
    }

    static {
        LensColorAction.names[0] = "Default";
        LensColorAction.names[1] = "Red";
        LensColorAction.names[2] = "Orange";
        LensColorAction.names[3] = "Yellow";
        LensColorAction.names[4] = "Green";
        LensColorAction.names[5] = "Blue";
        LensColorAction.names[6] = "Indigo";
        LensColorAction.names[7] = "Violet";
        LensColorAction.names[8] = "Black";
        LensColorAction.names[9] = "Light Gray";
        LensColorAction.names[10] = "Dark Gray";
        LensColorAction.names[11] = "White";
        colors = new Color[13];
        LensColorAction.colors[0] = LensUI.DEFAULT_LENS_COLOR;
        LensColorAction.colors[1] = Color.red;
        LensColorAction.colors[2] = Color.orange;
        LensColorAction.colors[3] = Color.yellow;
        LensColorAction.colors[4] = Color.green;
        LensColorAction.colors[5] = Color.blue;
        LensColorAction.colors[6] = new Color(75, 0, 130);
        LensColorAction.colors[7] = new Color(238, 130, 238);
        LensColorAction.colors[8] = Color.black;
        LensColorAction.colors[9] = Color.lightGray;
        LensColorAction.colors[10] = Color.darkGray;
        LensColorAction.colors[11] = Color.white;
    }
}

