/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import omero.gateway.model.ExperimenterData;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ExperimenterContext {
    private static final int MAX_CHARS = 25;
    public static final int ALL_EXPERIMENTERS_ID = Integer.MAX_VALUE;
    private String experimenter;
    private long id;

    public ExperimenterContext(String experimenter, long id) {
        if (experimenter.length() > 25) {
            experimenter = UIUtilities.truncate(experimenter, 25, false);
        }
        this.experimenter = experimenter;
        this.id = id;
    }

    public ExperimenterContext(ExperimenterData exp) {
        Object fName = exp.getFirstName();
        String lName = exp.getLastName();
        if (((String)fName).length() + lName.length() > 25 && ((String)(fName = ((String)fName).charAt(0) + ".")).length() + lName.length() > 25) {
            int left = 25 - ((String)fName).length();
            lName = UIUtilities.truncate(lName, left, false);
        }
        this.experimenter = (String)fName + " " + lName;
        this.id = exp.getId();
    }

    public long getId() {
        return this.id;
    }

    public String toString() {
        return this.experimenter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExperimenterContext other = (ExperimenterContext)obj;
        return this.id == other.id;
    }
}

