/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.util.ui.search;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openmicroscopy.shoola.util.ui.search.NodeCheckMenuItem;
import org.openmicroscopy.shoola.util.ui.search.NodeMenuItem;
import org.openmicroscopy.shoola.util.ui.search.NodeRadioMenuItem;
import org.openmicroscopy.shoola.util.ui.search.SearchObject;

public class SearchContextMenu
extends JPopupMenu
implements ActionListener {
    public static final String SEARCH_CONTEXT_PROPERTY = "searchContext";
    private int width;
    private Class type;
    private List items;
    private ButtonGroup group;

    private void buildGUI(List<SearchObject> nodes, List<SearchObject> ratedNodes, SearchObject selectedNode, boolean singleSelection) {
        JMenuItem uiNode;
        int index;
        this.group = new ButtonGroup();
        if (this.type.equals(NodeRadioMenuItem.class)) {
            index = -1;
            if (selectedNode != null) {
                index = selectedNode.getIndex();
            }
            for (SearchObject node : ratedNodes) {
                uiNode = new NodeRadioMenuItem(node);
                if (node.getIndex() == index) {
                    uiNode.setSelected(true);
                }
                uiNode.addActionListener(this);
                this.add(uiNode);
                this.items.add(uiNode);
                if (!singleSelection) continue;
                this.group.add(uiNode);
            }
            if (ratedNodes.size() > 0) {
                this.add(new JSeparator());
            }
            for (SearchObject node : nodes) {
                uiNode = new NodeRadioMenuItem(node);
                if (node.getIndex() == index) {
                    uiNode.setSelected(true);
                }
                uiNode.addActionListener(this);
                this.add(uiNode);
                this.items.add(uiNode);
                if (!singleSelection) continue;
                this.group.add(uiNode);
            }
        } else if (this.type.equals(NodeCheckMenuItem.class)) {
            index = -1;
            if (selectedNode != null) {
                index = selectedNode.getIndex();
            }
            for (SearchObject node : ratedNodes) {
                uiNode = new NodeCheckMenuItem(node);
                if (node.getIndex() == index) {
                    uiNode.setSelected(true);
                }
                uiNode.addActionListener(this);
                this.add(uiNode);
                this.items.add(uiNode);
                if (!singleSelection) continue;
                this.group.add(uiNode);
            }
            if (ratedNodes.size() > 0) {
                this.add(new JSeparator());
            }
            for (SearchObject node : nodes) {
                uiNode = new NodeCheckMenuItem(node);
                if (node.getIndex() == index) {
                    uiNode.setSelected(true);
                }
                uiNode.addActionListener(this);
                this.add(uiNode);
                this.items.add(uiNode);
                if (!singleSelection) continue;
                this.group.add(uiNode);
            }
        } else {
            for (SearchObject node : ratedNodes) {
                uiNode = new NodeMenuItem(node);
                uiNode.addActionListener(this);
                this.items.add(uiNode);
                this.add(uiNode);
            }
            if (ratedNodes.size() > 0) {
                this.add(new JSeparator());
            }
            for (SearchObject node : nodes) {
                uiNode = new NodeMenuItem(node);
                uiNode.addActionListener(this);
                this.add(uiNode);
                this.items.add(uiNode);
            }
        }
        int n = nodes.size() + ratedNodes.size();
        int height = this.getFontMetrics(this.getFont()).getHeight() * n + 10;
        this.setPopupSize(new Dimension(this.width, height));
    }

    public SearchContextMenu(List<SearchObject> nodes, List<SearchObject> ratedNodes, int width, boolean singleSelection) {
        this(nodes, ratedNodes, width, NodeMenuItem.class, null, singleSelection);
    }

    public SearchContextMenu(List<SearchObject> nodes, List<SearchObject> ratedNodes, int width, SearchObject selectedNode, boolean singleSelection) {
        this(nodes, ratedNodes, width, NodeRadioMenuItem.class, selectedNode, singleSelection);
    }

    SearchContextMenu(List<SearchObject> nodes, List<SearchObject> ratedNodes, int width, Class type, SearchObject selectedNode, boolean singleSelection) {
        this.type = type;
        this.width = width;
        this.items = new ArrayList();
        this.buildGUI(nodes, ratedNodes, selectedNode, singleSelection);
    }

    public void setSelectedNode(SearchObject node) {
        if (node == null) {
            this.group.clearSelection();
        } else {
            for (Object uiNode : this.items) {
                NodeRadioMenuItem rItem;
                if (uiNode instanceof NodeMenuItem) {
                    NodeMenuItem nmItem = (NodeMenuItem)uiNode;
                    if (nmItem.getSearchObject().getIndex() != node.getIndex()) continue;
                    nmItem.removeActionListener(this);
                    nmItem.setSelected(true);
                    nmItem.addActionListener(this);
                    continue;
                }
                if (uiNode instanceof NodeCheckMenuItem) {
                    NodeCheckMenuItem ncmItem = (NodeCheckMenuItem)uiNode;
                    if (ncmItem.getSearchObject().getIndex() != node.getIndex()) continue;
                    ncmItem.removeActionListener(this);
                    ncmItem.setSelected(true);
                    ncmItem.addActionListener(this);
                    continue;
                }
                if (!(uiNode instanceof NodeRadioMenuItem) || (rItem = (NodeRadioMenuItem)uiNode).getSearchObject().getIndex() != node.getIndex()) continue;
                rItem.removeActionListener(this);
                rItem.setSelected(true);
                rItem.addActionListener(this);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src instanceof NodeMenuItem) {
            NodeMenuItem item = (NodeMenuItem)src;
            this.firePropertyChange(SEARCH_CONTEXT_PROPERTY, null, item.getSearchObject());
        } else if (src instanceof NodeCheckMenuItem) {
            NodeCheckMenuItem item = (NodeCheckMenuItem)src;
            this.firePropertyChange(SEARCH_CONTEXT_PROPERTY, null, item.getSearchObject());
        } else if (src instanceof NodeRadioMenuItem) {
            NodeRadioMenuItem item = (NodeRadioMenuItem)src;
            this.firePropertyChange(SEARCH_CONTEXT_PROPERTY, null, item.getSearchObject());
        }
    }
}

