/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class HRDGDFReader
extends FormatReader {
    private static final String MAGIC_STRING = "SURFACE WIND COMPONENTS";
    private double[][] surfaceWind;

    public HRDGDFReader() {
        super("NOAA-HRD Gridded Data Format", "");
        this.domains = new String[]{"Unknown"};
        this.suffixSufficient = false;
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = MAGIC_STRING.length();
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)blockLen, (boolean)false)) {
            return false;
        }
        String check = stream.readString(blockLen);
        return check.equals(MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int nextBufIndex = 0;
        for (int row = y; row < h + y; ++row) {
            for (int col = x; col < w + x; ++col) {
                long v = Double.doubleToLongBits(this.surfaceWind[no][row * this.getSizeX() + col]);
                DataTools.unpackBytes(v, buf, nextBufIndex, 8, this.isLittleEndian());
                nextBufIndex += 8;
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.surfaceWind = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        String[] data = DataTools.readFile(id).split("[\r\n]");
        String hurricane = data[0].substring(data[0].lastIndexOf(" ") + 1);
        String pixelSize = data[1].substring(data[1].indexOf(32) + 1, data[1].lastIndexOf(" "));
        Double physicalSize = DataTools.parseDouble(pixelSize) * 1.0E9;
        String centerLine = data[2];
        centerLine = centerLine.replaceAll("STORM CENTER LOCALE IS ", "");
        String[] center = centerLine.split(" ");
        Double centerLongitude = DataTools.parseDouble(center[0]);
        Double centerLatitude = DataTools.parseDouble(center[5]);
        int lineNumber = 3;
        while (!data[lineNumber++].startsWith(MAGIC_STRING)) {
        }
        String dims = data[lineNumber++].trim();
        String x = dims.substring(0, dims.indexOf(32)).trim();
        String y = dims.substring(dims.indexOf(32) + 1).trim();
        this.surfaceWind = new double[2][Integer.parseInt(y) * Integer.parseInt(x)];
        int pixIndex = 0;
        while (lineNumber < data.length) {
            String line = data[lineNumber++];
            while (line.indexOf(40) != -1) {
                int end = line.indexOf(41);
                String pixel = line.substring(line.indexOf(40) + 1, end);
                line = line.substring(end + 1);
                int comma = pixel.indexOf(44);
                this.surfaceWind[0][pixIndex] = DataTools.parseDouble(pixel.substring(0, comma).trim());
                this.surfaceWind[1][pixIndex] = DataTools.parseDouble(pixel.substring(comma + 1).trim());
                ++pixIndex;
            }
        }
        this.addGlobalMeta("Hurricane", hurricane);
        this.addGlobalMeta("DX (kilometers)", pixelSize);
        this.addGlobalMeta("DY (kilometers)", pixelSize);
        this.addGlobalMeta("Storm center (Latitude)", centerLatitude);
        this.addGlobalMeta("Storm center (Longitude)", centerLongitude);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.sizeX = Integer.parseInt(x);
        m.sizeY = Integer.parseInt(y);
        m.sizeC = 2;
        m.rgb = false;
        m.pixelType = 7;
        m.sizeZ = 1;
        m.sizeT = 1;
        m.imageCount = this.getSizeC() * this.getSizeZ() * this.getSizeT();
        m.indexed = false;
        m.littleEndian = false;
        m.dimensionOrder = "XYCTZ";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX((Double)physicalSize);
            Length sizeY = FormatTools.getPhysicalSizeY((Double)physicalSize);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

