/*
 * Decompiled with CFR 0.152.
 */
package ome.util.mem;

public class ReadOnlyByteArray {
    protected final byte[] base;
    protected final int offset;
    public final int length;

    protected void checkIndex(int i) {
        if (i < 0 || this.length <= i) {
            throw new ArrayIndexOutOfBoundsException("Index not in [0, " + this.length + "): " + i + ".");
        }
    }

    public ReadOnlyByteArray(byte[] base, int offset, int length) {
        if (base == null) {
            throw new NullPointerException("No base.");
        }
        if (offset < 0 || length < 0 || base.length < offset + length) {
            throw new IllegalArgumentException("[offset=" + offset + ", offset+length=" + (offset + length) + "] not in [0, base.length=" + base.length + "].");
        }
        this.base = base;
        this.offset = offset;
        this.length = length;
    }

    public byte get(int index) {
        this.checkIndex(index);
        return this.base[this.offset + index];
    }
}

