/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import omero.RString;
import omero.gateway.model.ShapeData;
import omero.model.Polyline;
import omero.model.PolylineI;
import omero.model.Shape;
import omero.rtypes;

public class PolylineData
extends ShapeData {
    public PolylineData(Shape shape) {
        super(shape);
    }

    public PolylineData() {
        this(new ArrayList<Point2D.Double>());
    }

    public PolylineData(List<Point2D.Double> points) {
        super(new PolylineI(), true);
        this.setPoints(points);
    }

    public String getText() {
        Polyline shape = (Polyline)this.asIObject();
        RString value = shape.getTextValue();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setText(String text) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Polyline shape = (Polyline)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTextValue(rtypes.rstring(text));
        this.setDirty(true);
    }

    public List<Point2D.Double> getPoints() {
        String pts = this.fromPoints("points");
        return this.parsePointsToPoint2DList(pts);
    }

    public void setPoints(List<Point2D.Double> points) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Polyline shape = (Polyline)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        String pointsValues = PolylineData.toPoints(points.toArray(new Point2D.Double[points.size()]));
        shape.setPoints(rtypes.rstring(pointsValues));
        this.setDirty(true);
    }
}

