/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.Identity;
import Ice.ObjectNotExistException;
import Ice.ObjectPrx;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import ome.services.blitz.fire.TopicManager;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.blitz.util.ResultHolder;
import ome.system.EventContext;
import ome.system.Principal;
import omero.ServerError;
import omero.grid.ProcessorCallbackPrx;
import omero.grid.ProcessorCallbackPrxHelper;
import omero.grid.ProcessorPrx;
import omero.grid.ProcessorPrxHelper;
import omero.grid._ProcessorCallbackOperations;
import omero.grid._ProcessorCallbackTie;
import omero.model.ExperimenterGroupI;
import omero.model.ExperimenterI;
import omero.model.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorCallbackI
extends AbstractAmdServant
implements _ProcessorCallbackOperations {
    private static final Logger log = LoggerFactory.getLogger(ProcessorCallbackI.class);
    private final Job job;
    private final ServiceFactoryI sf;
    private final ResultHolder<ProcessorPrx> holder;
    private final AtomicInteger responses = new AtomicInteger(0);

    public ProcessorCallbackI(ServiceFactoryI sf) {
        this(sf, new ResultHolder<ProcessorPrx>(5000L), null);
    }

    public ProcessorCallbackI(ServiceFactoryI sf, ResultHolder<ProcessorPrx> holder, Job job) {
        super(null, null);
        this.sf = sf;
        this.job = job;
        this.holder = holder;
    }

    public int getResponses() {
        return this.responses.get();
    }

    public ProcessorPrx activateAndWait(Current current) throws ServerError {
        Identity acceptId = new Identity();
        acceptId.name = UUID.randomUUID().toString();
        acceptId.category = "ProcessorCallback";
        return this.activateAndWait(current, acceptId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessorPrx activateAndWait(Current current, Identity acceptId) throws ServerError {
        ObjectPrx prx = this.sf.registerServant(acceptId, new _ProcessorCallbackTie(this));
        try {
            prx = this.sf.adapter.createDirectProxy(acceptId);
            ProcessorCallbackPrx cbPrx = ProcessorCallbackPrxHelper.uncheckedCast(prx);
            EventContext ec = this.sf.getEventContext(current);
            TopicManager.TopicMessage msg = new TopicManager.TopicMessage(this, "/internal/ProcessorAccept", new ProcessorPrxHelper(), "willAccept", new ExperimenterI(ec.getCurrentUserId(), false), new ExperimenterGroupI(ec.getCurrentGroupId(), false), this.job, cbPrx);
            this.sf.topicManager.onApplicationEvent(msg);
            ProcessorPrx processorPrx = this.holder.get();
            return processorPrx;
        }
        finally {
            this.sf.unregisterServant(acceptId);
        }
    }

    @Override
    @Deprecated
    public void isAccepted(boolean accepted, String sessionUuid, String procConn, Current __current) {
        this.isProxyAccepted(accepted, sessionUuid, ProcessorPrxHelper.checkedCast(this.sf.adapter.getCommunicator().stringToProxy(procConn)), __current);
    }

    @Override
    public void isProxyAccepted(boolean accepted, String sessionUuid, ProcessorPrx procProxy, Current __current) {
        this.responses.incrementAndGet();
        Throwable exc = null;
        String reason = "because false returned";
        if (accepted) {
            String procLog = this.sf.adapter.getCommunicator().proxyToString((ObjectPrx)procProxy);
            log.debug(String.format("Processor with session %s returned %s accepted", sessionUuid, procLog, accepted));
            try {
                EventContext procEc = this.sf.sessionManager.getEventContext(new Principal(sessionUuid));
                EventContext ec = this.sf.getEventContext(__current);
                if (procEc.isCurrentUserAdmin() || procEc.getCurrentUserId().equals(ec.getCurrentUserId())) {
                    this.holder.set(ProcessorPrxHelper.checkedCast(procProxy));
                    return;
                }
                reason = "since disallowed";
            }
            catch (ObjectNotExistException onee) {
                exc = onee;
                reason = "due to ObjectNotExistException: " + procLog;
            }
            catch (Exception e) {
                exc = e;
                reason = "due to exception: " + e.getMessage();
            }
        }
        String msg = String.format("Processor with session %s rejected %s", sessionUuid, reason);
        if (exc != null) {
            log.warn(msg, exc);
        } else {
            log.debug(msg);
        }
        this.holder.set(null);
    }

    @Override
    public void responseRunning(List<Long> jobIds, Current __current) {
        log.error("responseRunning should not have been called");
    }
}

