/*
 * Decompiled with CFR 0.152.
 */
package ome.util.checksum;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import ome.util.checksum.ChecksumProvider;
import ome.util.checksum.ChecksumTestVector;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractChecksumProviderAlgorithmTest {
    ChecksumProvider checksumProvider;
    private File smallFile;
    private File mediumFile;
    private File bigFile;
    private EnumMap<ChecksumTestVector, String> checksumValues;

    public AbstractChecksumProviderAlgorithmTest(ChecksumProvider cp, EnumMap<ChecksumTestVector, String> checksumValues) {
        try {
            int index;
            String name = "smallFile.fake";
            this.smallFile = new File(System.getProperty("java.io.tmpdir"), name);
            this.smallFile.deleteOnExit();
            try (FileWriter out = new FileWriter(this.smallFile);){
                for (index = 0; index < 10; ++index) {
                    ((Writer)out).append("fake" + index);
                }
            }
            name = "mediumFile.fake";
            this.mediumFile = new File(System.getProperty("java.io.tmpdir"), name);
            this.mediumFile.deleteOnExit();
            out = new FileWriter(this.mediumFile);
            try {
                for (index = 0; index < 100; ++index) {
                    ((Writer)out).append("fake" + index);
                }
            }
            finally {
                ((Writer)out).close();
            }
            name = "bigFile.fake";
            this.bigFile = new File(System.getProperty("java.io.tmpdir"), name);
            this.bigFile.deleteOnExit();
            out = new FileWriter(this.bigFile);
            try {
                for (index = 0; index < 1000; ++index) {
                    ((Writer)out).append("fake" + index);
                }
            }
            finally {
                ((Writer)out).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("IOException during test set up.");
        }
        this.checksumProvider = cp;
        this.checksumValues = checksumValues;
    }

    @Test
    public void testChecksumAsStringWithByteArray() {
        String actual = this.checksumProvider.putBytes("abc".getBytes()).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.ABC));
    }

    @Test
    public void testChecksumAsStringWithPartOfByteArrayZeroOffset() {
        String actual = this.checksumProvider.putBytes("abcdef".getBytes(), 0, 3).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.ABC));
    }

    @Test
    public void testChecksumAsStringWithPartOfByteArrayNonZeroOffset() {
        String actual = this.checksumProvider.putBytes("defabc".getBytes(), 3, 3).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.ABC));
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testChecksumAsStringWithPartOfByteArrayShouldThrowIOOB() {
        this.checksumProvider.putBytes("abcdef".getBytes(), -1, -1);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPutBytesWithNullByteArrayShouldThrowNPE() {
        byte[] nullArray = null;
        this.checksumProvider.putBytes(nullArray);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testPutBytesWithChunkOfNullByteArrayShouldThrowNPE() {
        byte[] nullArray = null;
        this.checksumProvider.putBytes(nullArray, 123, 456);
    }

    @Test
    public void testChecksumAsStringWithEmptyByteArray() {
        String actual = this.checksumProvider.putBytes("".getBytes()).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.EMPTYARRAY));
    }

    @Test
    public void testChecksumAsStringWithByteBuffer() {
        String actual = this.checksumProvider.putBytes(ByteBuffer.wrap("abc".getBytes())).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.ABC));
    }

    @Test
    public void testChecksumAsStringWithTruncatedByteBuffer() {
        ByteBuffer buffer = ByteBuffer.wrap("abcdef".getBytes());
        buffer.position(0).limit(3);
        String actual = this.checksumProvider.putBytes(buffer).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.ABC));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testChecksumAsBytesWithEmptyByteBufferShouldThrowIAE() {
        byte[] actual = this.checksumProvider.putBytes(ByteBuffer.allocateDirect(0)).checksumAsBytes();
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testChecksumAsStringWithSmallFilePathString() {
        String actual = this.checksumProvider.putFile(this.smallFile.getAbsolutePath()).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.SMALLFILE));
    }

    @Test
    public void testChecksumAsStringWithMediumFilePathString() {
        String actual = this.checksumProvider.putFile(this.mediumFile.getAbsolutePath()).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.MEDIUMFILE));
    }

    @Test
    public void testChecksumAsStringWithBigFilePathString() {
        String actual = this.checksumProvider.putFile(this.bigFile.getAbsolutePath()).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.BIGFILE));
    }

    @Test
    public void testChecksumAsStringWithEmptyObject() {
        String actual = this.checksumProvider.checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.EMPTYARRAY));
    }

    @Test
    public void testChecksumAsStringWithSequentialPutBytes() {
        String actual = this.checksumProvider.putBytes("a".getBytes()).putBytes("bc".getBytes()).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.ABC));
    }

    @Test
    public void testChecksumAsStringWithMixedPutBytes() {
        String actual = this.checksumProvider.putBytes("abc".getBytes()).putFile(this.smallFile.getAbsolutePath()).checksumAsString();
        Assert.assertEquals((String)actual, (String)this.checksumValues.get((Object)ChecksumTestVector.SMALLFILE));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testPutBytesAfterChecksumAsString() {
        this.checksumProvider.putBytes("abc".getBytes()).checksumAsString();
        this.checksumProvider.putBytes("abc".getBytes());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testPutBytesAfterChecksumAsBytes() {
        this.checksumProvider.putBytes("abc".getBytes()).checksumAsBytes();
        this.checksumProvider.putBytes("abc".getBytes());
    }
}

