/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.application.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jhotdraw.application.DocumentView;
import org.jhotdraw.application.action.AbstractDocumentViewAction;
import org.jhotdraw.gui.JSheet;
import org.jhotdraw.gui.Worker;
import org.jhotdraw.gui.event.SheetEvent;
import org.jhotdraw.gui.event.SheetListener;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.util.ResourceBundleUtil;

public class SaveAction
extends AbstractDocumentViewAction {
    public static final String ID = "File.save";
    private boolean saveAs;
    private Component oldFocusOwner;

    public SaveAction() {
        this(false);
    }

    public SaveAction(boolean saveAs) {
        this.saveAs = saveAs;
        this.initActionProperties(ID);
    }

    public void actionPerformed(ActionEvent evt) {
        final DocumentView documentView = this.getCurrentView();
        if (documentView.isEnabled()) {
            this.oldFocusOwner = SwingUtilities.getWindowAncestor(documentView.getComponent()).getFocusOwner();
            documentView.setEnabled(false);
            if (!this.saveAs && documentView.getFile() != null) {
                this.saveToFile(documentView, documentView.getFile());
            } else {
                JFileChooser fileChooser = documentView.getSaveChooser();
                JSheet.showSaveSheet(fileChooser, documentView.getComponent(), new SheetListener(){

                    public void optionSelected(SheetEvent evt) {
                        if (evt.getOption() == 0) {
                            File file = evt.getFileChooser().getFileFilter() instanceof ExtensionFileFilter ? ((ExtensionFileFilter)evt.getFileChooser().getFileFilter()).makeAcceptable(evt.getFileChooser().getSelectedFile()) : evt.getFileChooser().getSelectedFile();
                            SaveAction.this.saveToFile(documentView, file);
                        } else {
                            documentView.setEnabled(true);
                            if (SaveAction.this.oldFocusOwner != null) {
                                SaveAction.this.oldFocusOwner.requestFocus();
                            }
                        }
                    }
                });
            }
        }
    }

    protected void saveToFile(final DocumentView documentView, final File file) {
        documentView.execute(new Worker(){

            public Object construct() {
                try {
                    documentView.write(file);
                    return null;
                }
                catch (IOException e) {
                    return e;
                }
            }

            public void finished(Object value) {
                SaveAction.this.fileSaved(documentView, file, value);
            }
        });
    }

    protected void fileSaved(DocumentView documentView, File file, Object value) {
        if (value == null) {
            documentView.setFile(file);
            documentView.setModified(false);
            this.getApplication().addRecentFile(file);
        } else {
            ResourceBundleUtil labels = ResourceBundleUtil.getLAFBundle("org.jhotdraw.application.Labels");
            JSheet.showMessageSheet((Component)documentView.getComponent(), (Object)("<html>" + UIManager.getString("OptionPane.css") + labels.getFormatted("couldntSave", file, value)), 0);
        }
        documentView.setEnabled(true);
        SwingUtilities.getWindowAncestor(documentView.getComponent()).toFront();
        if (this.oldFocusOwner != null) {
            this.oldFocusOwner.requestFocus();
        }
    }
}

