/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;

public class BoundsOutlineHandle
extends AbstractHandle {
    private static final Color HANDLE_STROKE_COLOR = new Color(43263);

    public BoundsOutlineHandle(Figure owner) {
        super(owner);
    }

    protected Rectangle basicGetBounds() {
        Shape bounds = this.getOwner().getBounds();
        if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            bounds = AttributeKeys.TRANSFORM.get(this.getOwner()).createTransformedShape(bounds);
        }
        bounds = this.view.getDrawingToViewTransform().createTransformedShape(bounds);
        Rectangle2D r = bounds.getBounds2D();
        return this.view.drawingToView(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
    }

    public boolean contains(Point p) {
        return false;
    }

    public void trackStart(Point anchor, int modifiersEx) {
    }

    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    public void draw(Graphics2D g) {
        Shape bounds = this.getOwner().getBounds();
        if (AttributeKeys.TRANSFORM.get(this.getOwner()) != null) {
            bounds = AttributeKeys.TRANSFORM.get(this.getOwner()).createTransformedShape(bounds);
        }
        bounds = this.view.getDrawingToViewTransform().createTransformedShape(bounds);
        g.setColor(HANDLE_STROKE_COLOR);
        g.draw(bounds);
    }
}

