/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import omero.gateway.model.DataObject;
import omero.gateway.model.ExperimenterData;
import omero.gateway.model.FileData;
import omero.gateway.model.ImageData;
import omero.gateway.model.WellSampleData;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplayVisitor;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;

public class ImageFinder
implements ImageDisplayVisitor {
    private Set<ImageDisplay> imageNodes;
    private Set<DataObject> images = new HashSet<DataObject>();
    private Set<ImageNode> visibleImageNodes;
    private Set<DataObject> visibleImages;

    public ImageFinder() {
        this.imageNodes = new HashSet<ImageDisplay>();
        this.visibleImages = new HashSet<DataObject>();
        this.visibleImageNodes = new HashSet<ImageNode>();
    }

    public Set<ImageDisplay> getImageNodes() {
        return this.imageNodes;
    }

    public Set<DataObject> getImages() {
        return this.images;
    }

    public Set<ImageNode> getVisibleImageNodes() {
        return this.visibleImageNodes;
    }

    public Set<DataObject> getVisibleImages() {
        return this.visibleImages;
    }

    @Override
    public void visit(ImageNode node) {
        this.imageNodes.add(node);
        this.visibleImageNodes.add(node);
        Object ho = node.getHierarchyObject();
        if (ho instanceof WellSampleData) {
            WellSampleData wsd = (WellSampleData)ho;
            ho = wsd.getImage();
        }
        if (ho instanceof ImageData) {
            this.images.add((ImageData)ho);
        }
    }

    @Override
    public void visit(ImageSet node) {
        if (node == null) {
            return;
        }
        JComponent desktop = node.getInternalDesktop();
        Component[] comps = desktop.getComponents();
        if (comps != null) {
            for (int i = 0; i < comps.length; ++i) {
                Component c = comps[i];
                if (!(c instanceof ImageNode)) continue;
                ImageNode n = (ImageNode)c;
                Object ho = n.getHierarchyObject();
                if (ho instanceof WellSampleData) {
                    WellSampleData wsd = (WellSampleData)ho;
                    ho = wsd.getImage();
                    continue;
                }
                if (ho instanceof ImageData) {
                    this.visibleImages.add((ImageData)ho);
                    this.visibleImageNodes.add(n);
                    continue;
                }
                if (ho instanceof FileData) {
                    this.visibleImages.add((FileData)ho);
                    this.visibleImageNodes.add(n);
                    continue;
                }
                if (!(ho instanceof ExperimenterData)) continue;
                this.visibleImages.add((ExperimenterData)ho);
                this.visibleImageNodes.add(n);
            }
        }
    }
}

